<?php
defined('ABSPATH') || exit;
/**
 * Plugin Name: ElementPress
 * Description: The most advanced addons for Elementor.
 * Plugin URI: https://devbunch.com/
 * Author: TeamDevBunch
 * Version: 4.3.3
 * Author URI: https://devbunch.com/
 *
 * Text Domain: elementpress
 *
 * @package ElementPress
 * @category Free
 *
 */
;
include_once(ABSPATH . 'wp-admin/includes/plugin.php');
register_activation_hook(__FILE__, 'elementpress_activate');

function elementpress_activate()
{
    if (file_exists(WP_PLUGIN_DIR . '/elementor/elementor.php') && is_plugin_active(WP_PLUGIN_DIR . '/elementor/elementor.php')) {
        add_option('ep_do_activation_redirect', true); //add option for redirection
    }
}

function redirect_to_dashboard()
{ //dashboard redirection function
    if (get_option('ep_do_activation_redirect', false)) {
        delete_option('ep_do_activation_redirect');
        if (!isset($_GET['activate-multi'])) {

            (wp_redirect(admin_url('admin.php?page=elementpress'))); //redirection
        }
    }
}

if (file_exists(WP_PLUGIN_DIR . '/elementor/elementor.php') && is_plugin_active(WP_PLUGIN_DIR . '/elementor/elementor.php')) {
    add_action('admin_init', 'redirect_to_dashboard'); //rediect to dashboard on admin intialization.
}


add_filter('plugin_action_links', 'add_settings_tab_in_plugin', 10, 2); //add settings link when activated plugin

function add_settings_tab_in_plugin($links, $file)
{
    if ($file == plugin_basename(dirname(__FILE__) . '/elementpress.php')) {
        $href = admin_url("admin.php?page=settings");

        $link = "<a href='$href'>" . __("Settings", "elementpress") . "</a>";
        array_unshift($links, $link);
    }
    return $links;
}

if (!class_exists('ElementPress')) :
    final class ElementPress
    {

        const MINIMUM_ELEMENTOR_VERSION = '2.4.0';
        const PACKAGE_TYPE = 'free';
        const version = '2.2.4';
        const MINIMUM_PHP_VERSION = '5.6';

        static function plugin_dir()
        {
            return trailingslashit(plugin_dir_path(__FILE__));
        }

        private static $_instance = null;

        public static function instance()
        { //create one instance of class (singleton)
            if (is_null(self::$_instance)) {
                self::$_instance = new self();
            }
            return self::$_instance;
        }

        static function plugin_url()
        {
            return trailingslashit(plugin_dir_url(__FILE__));
        }

        static function lib_dir()
        {
            return self::plugin_dir() . 'libs/';
        }

        static function admin_dir()
        {
            return self::plugin_dir() . 'admin/';
        }

        static function admin_url()
        {
            return self::plugin_url() . 'admin/';
        }

        static function addons_dir()
        {
            return self::plugin_dir() . 'addons/';
        }

        static function addons_url()
        {
            return self::plugin_url() . 'addons/';
        }

        static function widgets_url()
        {
            return self::plugin_url() . 'addons/widgets';
        }

        static function widgets_dir()
        {
            return self::plugin_dir() . 'addons/widgets/';
        }

        static function lib_url()
        {
            return self::plugin_url() . 'libs/';
        }


        static function api_url()
        {
            return 'https://api.wpmet.com/public/';
        }

        static function module_dir()
        {
            return self::plugin_dir() . 'modules/';
        }

        static function module_url()
        {
            return self::plugin_url() . 'modules/';
        }

        public static function get_url(){
            return \ElementPress::module_url() . 'controls/';
        }
        public static function get_dir(){
            return \ElementPress::module_dir() . 'controls/';
        }

        public function __construct()
        {

             


            add_action('init', array($this, 'i18n')); //call i18n (translation domain) on init
            add_action('admin_enqueue_scripts', array($this, 'load_admin_style')); //load admin styles
            add_action('plugins_loaded', [$this, 'load_helpers']); //call  after plugin is loaded
            $this->include_files();
            add_action('elementor/controls/controls_registered', array( $this, 'icon' ), 11 );
            add_action('elementor/controls/controls_registered', array( $this, 'image_choose' ), 11 );
            add_action('elementor/element/after_section_end', function ($section, $section_id) {
               
                if ('section_advanced' === $section_id || '_section_style' === $section_id) {

                    //Start Custom Settings Section
                    $section->start_controls_section(
                        'opt_css',
                        [
                            'label' => __('Elementpress CSS', 'elementpress'),
                            'tab' => \Elementor\Controls_Manager::TAB_ADVANCED,

                        ]
                    );

                    $section->add_control(
                        'front_note',
                        [
                            'type' => \Elementor\Controls_Manager::RAW_HTML,
                            'raw' => __('This Feature Only Works on the frontend.', 'elementpress'),
                            'content_classes' => 'elementor-descriptor',

                        ]
                    );

                    $repeater = new \Elementor\Repeater();
                    $repeater->add_control(
                        'break_title',
                        [
                            'label' => __('Title', 'elementpress'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => __('Default title', 'elementpress'),
                            'placeholder' => __('Type your title here', 'elementpress'),
                        ]
                    );

                    $repeater->add_control(
                        'break_enable',
                        [
                            'label' => __('Enable Media Query', 'elementpress'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'label_on' => __('Show', 'elementpress'),
                            'label_off' => __('Hide', 'elementpress'),
                            'return_value' => 'yes',
                            'default' => 'yes',
                        ]
                    );

                    $repeater->add_control(
                        'show_min',
                        [
                            'label' => __('Show Min', 'elementpress'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'label_on' => __('Show', 'elementpress'),
                            'label_off' => __('Hide', 'elementpress'),
                            'return_value' => 'yes',
                            'default' => 'yes',
                            'condition' => [
                                'break_enable' => 'yes',
                            ]
                        ]
                    );

                    $repeater->add_control(
                        'show_max',
                        [
                            'label' => __('Show Max', 'elementpress'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'label_on' => __('Show', 'elementpress'),
                            'label_off' => __('Hide', 'elementpress'),
                            'return_value' => 'yes',
                            'default' => 'yes',
                            'condition' => [
                                'break_enable' => 'yes',
                            ]
                        ]
                    );
                    $repeater->add_control(
                        'break_min',
                        [
                            'label' => __('Min Width (px)', 'elementpress'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'min' => 5,
                            'max' => 1000,
                            'step' => 5,
                            'default' => 0,
                            'condition' => [
                                'show_min' => 'yes',
                                'break_enable' => 'yes',
                            ]
                        ]
                    );
                    $repeater->add_control(
                        'break_max',
                        [
                            'label' => __('Max Width (px)', 'elementpress'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'min' => 5,
                            'max' => 3000,
                            'step' => 5,
                            'default' => 100,
                            'condition' => [
                                'show_max' => 'yes',
                                'break_enable' => 'yes',
                            ]
                        ]
                    );
                    $repeater->add_control(
                        'custom_css',
                        [
                            'type' => \Elementor\Controls_Manager::CODE,
                            'label' => __('Add Your Own Custom Css Here', 'elementpress'),
                            'language' => 'css',
                            'render_type' => 'ui',
                            'show_label' => false,
                            'separator' => 'none',
                        ]
                    );
                    $repeater->add_control(
                        'css_description',
                        [
                            'raw' => __('Use "selector" to target wrapper element. Examples:<br>selector {color: red;} // For main element<br>selector .child-element {margin: 10px;} // For child element<br>.my-class {text-align: center;} // Or use any custom selector', 'elementpress'),
                            'type' => \Elementor\Controls_Manager::RAW_HTML,
                            'content_classes' => 'elementor-descriptor',
                        ]
                    );
                    $section->add_control(
                        'breakpoints_list',
                        [
                            'label' => __('Add Your Own Custom Css Here', 'elementpress'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'fields' => $repeater->get_controls(),
                            'default' => [
                                [
                                    'break_title' => __('Title #1', 'elementpress'),
                                    'break_enable' => __('yes', 'elementpress'),
                                    'show_min' => __('yes', 'elementpress'),
                                    'show_max' => __('yes', 'elementpress'),
                                    'break_min' => __('Min', 'elementpress'),
                                    'break_max' => __('Max', 'elementpress'),
                                    'custom_css' => __('', 'elementpress'),
                                ],
                            ],
                            'title_field' => '{{{ break_title }}}',
                        ]
                    );
                    #End Custom Settings Section
                    $section->end_controls_section();
                }
            }, 10, 2);
            //Control register for backend
            add_action('elementor/frontend/before_render', function (\Elementor\Element_Base $section) {
                $dir = getcwd() . "/wp-content/uploads/elementpress";
                if (is_dir($dir) === false) {
                    mkdir($dir);
                }
                $text = '';
                foreach ($section->get_settings_for_display('breakpoints_list') as $item) {
                    if ($item['break_enable']) {
                        if ($item['show_min'] == 'yes') {
                            $text = '
											@media screen and (min-width:' . $item['break_min'] . 'px){'
                                . $item['custom_css'] .
                                '}';
                        } elseif ($item['show_max'] == 'yes') {
                            $text = '
											@media screen and (max-width:' . $item['break_max'] . 'px){'
                                . $item['custom_css'] .
                                '}';
                        }
                        if ($item['show_min'] == 'yes' && $item['show_max'] == 'yes') {
                            $text = '
											@media  (min-width:' . $item['break_min'] . 'px) and (max-width:' . $item['break_max'] . 'px){'
                                . $item['custom_css'] .
                                '}';
                        }
                    } else {
                        $text = $item['custom_css'];
                    }
                    if ($item['break_min'] === 'Min' || $item['break_max'] === 'Max' || $item['custom_css'] === '') {
                    } else {
                        $filename = $dir . "/post-" . $item['_id'] . ".css";
                        $fh = fopen($filename, "w");
                        fwrite($fh, $text);
                        wp_enqueue_style('custom-breakpoint' . $item['_id'], '/wp-content/uploads/elementpress/post-' . $item['_id'] . '.css', false, true,'all');
                        fclose($fh);
                    }
                }
            }, 11);
            add_action( 'wp_enqueue_scripts', [$this,'ep_theme_name_scripts'] );
        }


        private function include_files(){
            if (file_exists(WP_PLUGIN_DIR . '/elementor/elementor.php') && is_plugin_active(WP_PLUGIN_DIR . '/elementor/elementor.php')) {
            // Controls_Manager
            include_once self::get_dir() . 'control-manager.php';
            // image choose
            include_once self::get_dir() . 'image-choose.php';
            // ajax select2
            include_once self::get_dir() . 'ajax-select2.php';
            include_once self::get_dir() . 'icon.php';
            
            // widgetarea
            include_once self::get_dir() . 'widget-area-utils.php';
            include_once self::get_dir() . 'widget-area.php';
            }
   
      }
      public function icon( $controls_manager ) {
          $controls_manager->unregister_control( $controls_manager::ICON );
          $controls_manager->register_control( $controls_manager::ICON, new \ElementPress\Modules\Controls\Icon());
      }
  
     
      public function image_choose( $controls_manager ) {
          $controls_manager->register_control('imagechoose', new \ElementPress\Modules\Controls\Image_Choose());
      }
      public function widgetarea( $controls_manager ) {
          $controls_manager->register_control( 'widgetarea', new \ElementPress\Modules\Controls\Widget_Area());
      }




        /**
         * Proper way to enqueue scripts and styles
         */
        function ep_theme_name_scripts() {
            wp_enqueue_style( 'elementpress-nav-menu-css', \ElementPress::widgets_url() . '/nav-menu/assets/css/style.css' );
        }

        static function default_widgets($package = null)
        {
            $package = ($package != null) ? $package : self::PACKAGE_TYPE;
            $default_list = [
                'sharepost',
                'posttitle',
                'metapost',
                'postcontent',
                'postcoments',
                'postbreadcrumbs',
                'postimage',
                'callofaction',
                'postauthorimage',
                'nav-menu',
                'searchpost',
                'blogpost',
                'price',
                'search',
                'input',
                'vspslider',
                'team',
                'testimonial',

            ];
            return $default_list;
        }

        function i18n()
        { //translation text domain

            $path = trailingslashit(dirname(plugin_dir_url(__FILE__)));
            load_plugin_textdomain('elementpress', false, $path . '/languages/');
        }

        function load_admin_style()
        { //function to load admin style

            $path = trailingslashit(dirname(plugin_dir_url(__FILE__)));
            wp_enqueue_style('notics_style', self::plugin_url() . '/admin/assets/css/notics-style.css', null, self::version, 'all');
            if (is_admin() && !wp_style_is('admin_style', 'enqueued')) { //check if its a admin interface and style is enqueued already

                wp_enqueue_style('admin_style', self::plugin_url() . '/admin/assets/css/admin_style.css', null, self::version, 'all');
                wp_enqueue_style('elementpress-lib-css-admin', self::plugin_url() . '/admin/assets/css/framework.css', self::version);
            }
            if (is_admin() && !wp_script_is('admin_js', 'enqueued')) { //check if its a admin interface and script is enqueued already

                wp_enqueue_script('admin_js', self::plugin_url() . '/admin/assets/js/admin_style.js', null, self::version, 'all');
                wp_enqueue_script('elementpress-admin-core-ui', self::plugin_url() . '/admin/assets/js/core-ui.min.js', self::version, true);
            }
        }

        function load_helpers()
        {
            // Load the main static helper class.
            require_once self::plugin_dir() . '/helpers/notice.php'; //Elementor Missing Notice Code
            require_once self::plugin_dir() . '/helpers/utils.php'; // Create Cpt Code
            require_once self::widgets_dir().'/slider/assets/helper.php';
            if (file_exists(WP_PLUGIN_DIR . '/elementor/elementor.php') && is_plugin_active(WP_PLUGIN_DIR . '/elementor/elementor.php')) {
            require_once self::widgets_dir().'/slider/assets/slider_manager.php';
            }
            require_once self::plugin_dir() . '/addons/addons.php'; // Elementpress Categories File
            require_once self::plugin_dir() . '/addons/widgets.php'; // Elementpress widgets register File
            require_once self::plugin_dir() . '/addons/widgets/epress_blogs/epress_blogs.php'; //epic-blog-widget file
            add_action('elementor/elements/categories_registered', 'add_elementor_widget_categories'); //Register Cutom Addon Categories
            add_action('elementor/widgets/widgets_registered', 'init_widgets'); //register widgets

            if (!did_action('elementor/loaded')) { // Check if Elementor installed and activated
                add_action('admin_notices', [$this, 'missing_elementor_notice']); //show message
                return;
            }
            add_action('elementor/init', function () {

                require_once self::plugin_dir() . '/handler.php';
            });
        }

        static function default_modules($package = null)
        {
            $package = ($package != null) ? $package : self::PACKAGE_TYPE;
            $default_list = [
                'header-footer',
                'controls',
                'megamenu',
                'library',
                'dynamic-content',
                'epress-forms',
                'sticky_header',

            ];
            if (file_exists(WP_PLUGIN_DIR . '/woocommerce/woocommerce.php') && (is_plugin_active_for_network('woocommerce/woocommerce.php') || is_plugin_active(WP_PLUGIN_DIR . '/woocommerce/woocommerce.php'))) {

                $pro_list = ['woocommerce'];
            } else {
                $pro_list = [];
            }
            $default_list = array_merge($default_list, $pro_list);
            return $default_list;

            //return  $default_list;
        }

        function missing_elementor_notice()
        { //function to show elementor missing meesage

            if (file_exists(WP_PLUGIN_DIR . '/elementor/elementor.php')) {
                $btn['label'] = esc_html__('Activate Elementor', 'elementpress');
                $btn['url'] = wp_nonce_url('plugins.php?action=activate&plugin=elementor/elementor.php&plugin_status=all&paged=1', 'activate-plugin_elementor/elementor.php');
            } else {
                $btn['label'] = esc_html__('Install Elementor', 'elementpress');
                $btn['url'] = wp_nonce_url(self_admin_url('update.php?action=install-plugin&plugin=elementor'), 'install-plugin_elementor');
            }
            \ElementPress\Notice::sendParams(
                [

                    'type' => 'error',
                    'dismissible' => true,
                    'btn' => $btn,
                    'message' => '',
                ]
            );
        }
    }

    ;
    new ElementPress(); //load one instance of ElementPress class
endif;
