<?php
namespace Elementor;
use \Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;
class Elementpress_Widget_vspslider extends Widget_Base {

	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);

		wp_register_script( 'jquery-ui-vps', \ElementPress::widgets_url() .'/vpsslider/assets/js/jquery-ui.js', array( 'jquery' ), \ElementPress::version, true );
		wp_register_script( 'touch-punch-vps',  \ElementPress::widgets_url() .'/vpsslider/assets/js/touch-punch.js', array( 'jquery' ), \ElementPress::version, true);
		wp_register_script( 'slider_setting-vps',  \ElementPress::widgets_url() .'/vpsslider/assets/js/slider_setting.js', array( 'jquery' ), \ElementPress::version, true );

		wp_enqueue_style( 'vps-slidercss-vps',  \ElementPress::widgets_url() . '/vpsslider/assets/css/vps-slider.css', false, \ElementPress::version );
		wp_enqueue_style( 'vps-priceslidercss-vps', \ElementPress::widgets_url() . '/vpsslider/assets/css/priceslider.css', false, \ElementPress::version );
		add_action( 'wp_print_styles', array( $this, 'register_widget_styles' ) );

		// wp_register_style( 'vps-slidercss-vps',  \ElementPress::widgets_url() . '/vpsslider/assets/css/vps-slider.css', false, \ElementPress::version );
		// wp_register_style( 'vps-priceslidercss-vps', \ElementPress::widgets_url() . '/vpsslider/assets/css/priceslider.css', false, \ElementPress::version );


	 }
	 public function register_widget_styles(){
	 }
	 public function get_script_depends() {
		
		 return [ 'jquery-ui-vps','touch-punch-vps','slider_setting-vps' ];
	  }
  
	//   public function get_style_depends() {
		 
	// 	 return [ 'vps-priceslidercss-vps','vps-slidercss-vps' ];
	//   }
    public function get_name() {
		//get widget name from vpslider-handler.php file
		return 'elementpress-vspslider';
    }
    public function get_title() {
		//get widget title from vpslider-handler.php file
        return esc_html__( 'Vps Slider', 'elementpress' );
    }
    public function get_icon() {
		//get widget icon from vpslider-handler.php file
		return 'eicon-slider-3d';
    }
    public function get_categories() {
		//get widget category from vpslider-handler.php file
        return [ 'additional-addons' ];
	}
	//register controls
    protected function register_controls() {
		//Vps slider content section inside vps slider widget
        $this->start_controls_section(
			'content_section',
			[
				'label' => __('Vps Slider', 'elementpress' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
        );

        
	//currency text control inside Vps slider content section
        $this->add_control(
			'currency',
			[
				'label' => __( 'Enter You Currency', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$', 'elementpress' ),
				'placeholder' => __( 'Enter Your Currency Symbol', 'elementpress' ),
			]
		);

        $this->add_control(
            'defualt_position',
            [
                'label' => __( 'Enter You Default Position', 'elementpress' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '1', 'elementpress' ),
            ]
        );
		// button text control inside Vps slider content section
        $this->add_control(
			'btn_txt',
			[
				'label' => __( 'Order Button Text', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Order Now', 'elementpress' ),
				'placeholder' => __( 'Enter Your Custom Order Button Text', 'elementpress' ),
			]
		);
		//price period control inside Vps slider content section
        $this->add_control(
			'period_text',
			[
				'label' => __( 'Enter Your price period', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'mo', 'elementpress' ),
				'placeholder' => __( 'Enter Your price period', 'elementpress' ),
			]
		);
		//show coupan switcher inside vps slider content section
		$this->add_control(
			'show_coupon',
			[
				'label' => __( 'Show Coupon', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'elementpress' ),
				'label_off' => __( 'Hide', 'elementpress' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		//coupan code text inside vps slider content section
        $this->add_control(
			'coupon_text',
			[
				'label' => __( 'Enter Your (Coupon Code) Custom text', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Coupon Code', 'elementpress' ),
				'placeholder' => __( 'Enter Your (Coupon Code) Custom text', 'elementpress' ),
			]
		);
		//promo code text value inside vps slider content section
        $this->add_control(
			'coupon_code_value',
			[
				'label' => __( 'Promo Code Value', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '30% OFF', 'elementpress' ),
				'placeholder' => __( 'Enter Promo Code Value', 'elementpress' ),
			]
        );
        //promo code text  inside vps slider content section
        $this->add_control(
			'coupon_code',
			[
				'label' => __( 'Promo Code', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'LVPS30', 'elementpress' ),
				'placeholder' => __( 'Enter Promo Code', 'elementpress' ),
			]
		);
		//options controls
		//option 1 title control
		$this->add_control(
			'opt1name',
			[
				'label' => __( 'Option 1 Title', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Option 1', 'elementpress' ),
				'placeholder' => __( 'Enter Value', 'elementpress' ),
			]
		);
		//option 1 choose icon control
        $this->add_control(
			'image1url',
			[
				'label' => __( 'Option 1 Icon', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
			//option 2 title control
        $this->add_control(
			'opt2name',
			[
				'label' => __( 'Option 2 Title', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Option 2', 'elementpress' ),
				'placeholder' => __( 'Enter Value', 'elementpress' ),
			]
		);
			//option 2 choose icon control
        $this->add_control(
			'image2url',
			[
				'label' => __( 'Option 2 Icon', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		//option 3 title control
        $this->add_control(
			'opt3name',
			[
				'label' => __( 'Option 3 Title', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Option 3', 'elementpress' ),
				'placeholder' => __( 'Enter Value', 'elementpress' ),
			]
		);
			//option 3 icon control
        $this->add_control(
			'image3url',
			[
				'label' => __( 'Option 3 Icon', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		//option 4 title control
        $this->add_control(
			'opt4name',
			[
				'label' => __( 'Option 1 Title', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Option 1', 'elementpress' ),
				'placeholder' => __( 'Enter Value', 'elementpress' ),
			]
		);
		//option 4 icon control
        $this->add_control(
			'image4url',
			[
				'label' => __( 'Option 1 Icon', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		//Padding min (number control)
		$this->add_control(
			'paddingMin',
			[
				'label' => __( 'Padding Min', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 5,
				'max' => 10000,
				'step' => 5,
				'default' => 50,
			]
		);
		//Max padding control
		$this->add_control(
			'paddingMax',
			[
				'label' => __( 'Padding Max', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 5,
				'max' => 10000,
				'step' => 5,
				'default' => 80,
			]
		);
			//Repeater (things which could be repeated)
		$repeater = new \Elementor\Repeater();
		//plan name text control
        $repeater->add_control(
			'plan_name',
			[
				'label' => __( 'Plan Name', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Plan 1', 'elementpress' ),
				'placeholder' => __( 'Enter Plan Name', 'elementpress' ),
			]
		);
		//plan price text control
        $repeater->add_control(
			'plan_price',
			[
				'label' => __( 'Plan Price', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$89.00', 'elementpress' ),
				'placeholder' => __( 'Enter Plan Price', 'elementpress' ),
			]
		);
		//discount price  text control
		$repeater->add_control(
			'discount_price',
			[
				'label' => __( 'Discount Price', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$69.00', 'elementpress' ),
				'placeholder' => __( 'Enter Discount Price', 'elementpress' ),
			]
        );
		//option1 value text control
        $repeater->add_control(
			'opt1value',
			[
				'label' => __( 'Option 1 value', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$53', 'elementpress' ),
				'placeholder' => __( 'Enter Value', 'elementpress' ),
			]
		);
		//option2 value text control
        $repeater->add_control(
			'opt2value',
			[
				'label' => __( 'Option 2 value', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$44', 'elementpress' ),
				'placeholder' => __( 'Enter Value', 'elementpress' ),
			]
		);
		//option3 value text control
        $repeater->add_control(
			'opt3value',
			[
				'label' => __( 'Option 3 value', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$76', 'elementpress' ),
				'placeholder' => __( 'Enter Value', 'elementpress' ),
			]
		);
		//option4 value text control
        $repeater->add_control(
			'opt4value',
			[
				'label' => __( 'Option 4 value', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$98', 'elementpress' ),
				'placeholder' => __( 'Enter Value', 'elementpress' ),
			]
		);
		//Url control
		$repeater->add_control(
			'plan_order_link',
			[
				'label' => __( 'Plan Order Link', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'elementpress' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		//repater control
		$this->add_control(
			'plain_list',
			[
				'label' => __( 'Plain List', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'plan_name' => __('Plan 1', 'elementpress' ),
						'plan_price'=>__('$89.00', 'elementpress' ),
						'discount_price'=>__('$69.00', 'elementpress' ),
						'opt1name'=>__('Option 1', 'elementpress' ),
						'image1url'=>Utils::get_placeholder_image_src(),
						'opt2name'=>__('Option 2', 'elementpress' ),
						'image2url'=>Utils::get_placeholder_image_src(),
						'opt3name'=>__('Option 3', 'elementpress' ),
						'image3url'=>Utils::get_placeholder_image_src(),
						'opt4name'=>__('Option 4', 'elementpress' ),
						'image4url'=>Utils::get_placeholder_image_src(),
						'opt1value'=>__('$','elementpress'),
						'opt2value'=>__('$','elementpress'),
						'opt3value'=>__('$','elementpress'),
						'opt3value'=>__('$','elementpress'),
						'plan_order_link'=>__('https://your-link.com','elementpress'),
					],
				],
				'title_field' => '{{{ plan_name }}}',
			]
		);
		//custom code (code control)
		$this->add_control(
			'custom_css',
			[
				'label' => __( 'Custom Code', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::CODE,
				'language' => 'html',
				'rows' => 20,
			]
		);
        $this->end_controls_section();
	}
	//front end rendering
    protected function render() {
		$settings = $this->get_settings_for_display(); //get all the above settings
		echo $settings['custom_css'];
		?>
        <section class="padding_bottom_100 padding_top_100 text-center float-left w-100 bg_color_f4f8fa">
    <div class="container">
        <div class="heading-spacer col-xs-12"></div>
        <div class="slider-container bg_color_fafafa">
		
            <div class="price_rangetxt flex-container">
				<?php 
				foreach($settings['plain_list'] as $key=>$item)
				{
					if($key<10)
					{
					?>

					<div id="icon-<?php echo $key?>" class="icon"><span><?=$item['plan_name']?></span></div>

			<?php
			$count=$key+1;
					}
		}
			?>

			
              
                <!--price_rangetxt-->
            </div>
            <div class="slider_node float-left w-100 bg_color_424357 padding_bottom_150">
                <div class="price-slider-section col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12 float-left">
                    <div class="sliderbox">
                        <div id="slider"></div>
                        <!--sliderbox-->
                    </div>
                    <div class="clear"></div>
                </div>
			</div>
			
            <div class="slider_detail float-left w-100">
                <div class="col-xl-12 col-lg-12 col-md-12 float-left padding_tb_40 border_tb margin_top-170">
				
                    <div id="cpu_val" class="col-xl-3 col-lg-3 col-md-3 col-3 float-left price_content">
                        <div class="inner_price_content float-left w-100">
                            <div class="image_holder float-left w-100"><span><img alt="" src="<?=$settings['image1url']['url']?>"> </span></div>
                            <div class="value_text float-left w-100"><?=$settings['opt1name']?><br> <span class="value"></span>  </div>
                        </div>
                        <!--smallbox-->
                    </div>
                    <div id="ram_val" class="col-xl-3 col-lg-3 col-md-3 col-3 col-xs-3 float-left price_content">
                        <div class="inner_price_content float-left w-100">
                        <div class="image_holder float-left w-100"><span><img alt="" src="<?=$settings['image2url']['url']?>"> </span></div>
                        <div class="value_text float-left w-100"><?=$settings['opt2name']?><br> <span class="value"></span></div>
                        </div>
                        <!--smallbox-->
                    </div>
                    <div id="hdd_val" class="col-xl-3 col-lg-3 col-md-3 col-3 col-xs-3 float-left price_content">
                        <div class="inner_price_content float-left w-100">
                        <div class="image_holder float-left w-100"><span><img alt="" src="<?=$settings['image3url']['url']?>"> </span></div>
                        <div class="value_text float-left w-100"><?=$settings['opt3name']?><br> <span class="value"></span> </div>
                        </div>
                        <!--smallbox-->
                    </div>
                    <div id="bandwidth_val" class="col-xl-3 col-lg-3 col-md-3 col-3 col-xs-3 float-left price_content">
                        <div class="inner_price_content float-left w-100">
                        <div class="image_holder float-left w-100"><span><img alt="" src="<?=$settings['image4url']['url']?>"> </span></div>
                        <div class="value_text float-left w-100"><?=$settings['opt4name']?><br> <span class="value"></span> </div>
                        </div>
                        <!--smallbox-->
					</div>
					
                </div>
                <div class="col-xl-12 col-lg-12 col-md-12 float-left w-100 slider_price_box">
                        <div class="d-inline-block">
                            <div class="price_txt smallbox"><span id="price_val" class="numeric1"></span><?=$settings['period_text']?></div>
                        </div>
						<a href="https://www.your-domain.com/?cmd=cart&amp;action=add&amp;id=250" class="vps_btn buynow-button"><?=$settings['btn_txt']?></a>
						<?php if($settings['show_coupon']=='yes')
						{?>
						<div class="price_offer"><span class="off"><?=$settings['coupon_code_value']?></span> <br><span class='coupon_text'> <?=$settings['coupon_text']?> : </span><span><?=$settings['coupon_code']?></span></div>
						<?php } ?>
                        <div class="clear"></div>
                </div>
			</div>
				
        </div>
	</div>
	<?php
	$value1= $value2=  $value3= $value4= $pln_price= $pln_order_link= array();

	foreach($settings['plain_list'] as $items)
	{
		$value1[]=$items['opt1value'];
		$value2[]=$items['opt2value'];
		$value3[]=$items['opt3value'];
		$value4[]=$items['opt4value'];
		$pln_price[]=$items['plan_price'];
		$pln_order_link[]=$items['plan_order_link']['url'];
	}
	
	?>
</section>
<script >

var cpu_arr = new Array(<?php echo "'" . implode ( "', '", $value1 ) . "'";?>);
var ram_arr = new Array(<?php echo "'" . implode ( "', '", $value2 ) . "'";?>);
var hdd_arr = new Array(<?php echo "'" . implode ( "', '", $value3 ) . "'";?>);
var bandwidth_arr = new Array(<?php echo "'" . implode ( "', '", $value4 ) . "'";?>);
var ip_arr = new Array('3 IPs', '5 IPs', '7 IPs', '9 IPs', 'Unlimited')
var price_arr = new Array(<?php echo "'" . implode ( "', '", $pln_price ) . "'";?>);
var link_arr = new Array('$10', '$25', '$50', '$75', '$100', '$125');
var b_url = new Array(<?php echo "'" . implode ( "', '", $pln_order_link ) . "'";?>);
	var def_pos = <?= $settings['defualt_position'] ?>;

	jQuery(document).ready(function() {

		jQuery("#slider").slider({
        range: 'min',
        animate: true,
        min: 1,
        max: <?php echo $count;?>,
        paddingMin: <?=$settings['paddingMin']?>,
        paddingMax: <?=$settings['paddingMax']?>,
        change: function(event, ui) {
            jQuery('.slider-container #cpu_val span.value').html(cpu_arr[ui.value - 1]);
            jQuery('.slider-container #ram_val span.value').html(ram_arr[ui.value - 1]);
            jQuery('.slider-container #hdd_val span.value').html(hdd_arr[ui.value - 1]);
            jQuery('.slider-container #bandwidth_val span.value').html(bandwidth_arr[ui.value - 1]);
            jQuery('.slider-container #ip_val span.value').html(ip_arr[ui.value - 1]);
            jQuery('.slider-container #price_val').html(price_arr[ui.value - 1]);
            jQuery('.slider-container a.buynow-button').attr('href', b_url[ui.value - 1]);
            jQuery('.slider-container div.price_rangetxt div#icon-' + (ui.value - 1)).addClass("current");
            jQuery('.slider-container #sub-heading-' + (ui.value - 1)).addClass("current1");

        }
    });
    jQuery("#amount").val("$" + jQuery("#slider").slider("value"));
    jQuery('#slider').slider('value', def_pos);
    jQuery('.icon').click(function() {
        ch_value = parseInt(this.id.slice(5)) + 1;
        jQuery(".slider-container div.price_rangetxt div").removeClass("current");
        jQuery(".slider-container .heading div").removeClass("current1");
        jQuery('#slider').slider('value', ch_value);
    });
});
</script>
	<?php
  }
    protected function content_template() { }
}