<?php
namespace Elementor;
use \Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;
class Elementpress_Widget_search extends Widget_Base {
    public $base;
    
    public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);



        wp_register_style( 'search-css',  \ElementPress::widgets_url() . '/search/search.css', false, \ElementPress::version );
  
     }
  
	  public function get_style_depends() {
		 
		 return [ 'search-css' ];
	  }
    public function get_name() {
        //get name from search-handler.php file
        return 'elementpress-search';
    }
    public function get_title() {
        //get title from search-handler.php file
        return esc_html__( 'Search', 'elementpress' );
    }
    public function get_icon() {
        //get icon from search-handler.php file
        return 'eicon-search-bold';
    }
    public function get_categories() {
        //get categories from search-handler.php file
        return [ 'elementpress_singlepost' ];
    }
    //register controls
    protected function register_controls() {
        //search section inside search widget
        $this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Search', 'elementpress' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
        );
        
        
        $this->end_controls_section();
        
    }
    //front end rendering
    protected function render() {
        $settings = $this->get_settings_for_display();
        $unique_id = esc_attr( self::wp_get_unique_id( 'search-form-' ) );
        ?>
       <form class="form-inline" role="search" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
       <label for="<?php echo $unique_id; ?>">
		<span class="screen-reader-text"><?php echo _x( 'Search for:', 'label', 'hostiko' ); ?></span>
	</label>
                    <div id="myOverlay" class="overlay">
                        <span class="closebtn" id="closebtn" title="Close Overlay">×</span>
                        <div class="overlay-content">
                            <form action="#">
                                <input type="text" placeholder="What are you looking for?" value="<?php echo get_search_query(); ?>" name="s">
                                <button type="submit"><i class="fa fa-search"></i></button>
                            </form>
                        </div>
                    </div>
                    <div class="openBtn" id="openBtn">
                        <i class="fa fa-search"></i>
                    </div>
                </form>
                <script>
                jQuery('#openBtn').on('click', this, function() {

document.getElementById("myOverlay").style.display = "block";
});
jQuery('#closebtn').on('click', this, function() {

document.getElementById("myOverlay").style.display = "none";
});
                </script>
  
            
        <?php
        
}
function wp_get_unique_id( $prefix = '' ) {
	static $id_counter = 0;
	if ( function_exists( 'wp_unique_id' ) ) {
		return wp_unique_id( $prefix );
	}
	return $prefix . (string) ++$id_counter;
}
    protected function content_template() { }
}