<?php
namespace Elementor;
use \Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography as Scheme_Typography;
Use Elementor\Core\Schemes\Color as Scheme_Color;

if ( ! defined( 'ABSPATH' ) ) exit;
class Elementpress_Widget_postbreadcrumbs extends Widget_Base {
	public $base;
    public function get_name() {
		//get widget name from postbreadcrumbs-handler.php file
		return 'elementpress-postbreadcrumbs';
	}
	//get widget title from postbreadcrumbs-handler.php file
    public function get_title() {
		return esc_html__( 'Post Bread Crumbs', 'elementpress' );
	}
	//get widget icon from postbreadcrumbs-handler.php file
    public function get_icon() {
		return 'eicon-product-breadcrumbs';
	}
	//get widget category from postbreadcrumbs-handler.php file
    public function get_categories() {
        return [ 'elementpress_singlepost' ];
	}
	//register controls
    protected function register_controls() {
		//$defaultColorsCode = \Elementor\Core\Schemes\Color::get_default_scheme();
		//$defaultColorsCode = Scheme_Color::get_default_scheme();
		//Single Post BreadCrumbs section inside single post breadcrumbs widget
        $this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Single Post BraedCrumbs', 'elementpress' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		//alignment control inside Single Post BreadCrumbs section
		$this->add_control(
			'breadcrumbs_align',
			[
				'label' => __( 'Alignment', 'elementpress' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'elementpress' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'elementpress' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'elementpress' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'selectors' => [
					'{{WRAPPER}} .breadcrumb_opt' => 'text-align: {{VALUE}};',
				],
				'separator' => 'before',
			]
		);
        $this->end_controls_section(); //end Single Post BreadCrumbs section
		//style section after Single Post BreadCrumbs section
		$this->start_controls_section(
			'style_section',
			[
				'label' => __( 'Style', 'elementpress' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		//typography control under style section
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'breadcrumbs_typography',
				'label' => __( 'Typography', 'elementpress' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .breadcrumb_opt li',
			]
        );
        //Color picker control under style section
         $this->add_control(
        	'breadcrumbs_color',
        	[
        		'label' => __( 'BreadCrumbs Color Text', 'elementpress' ),
        		'type' => Controls_Manager::COLOR,
        		'scheme' => [
        			'type' => \Elementor\Core\Schemes\Color::get_type(),
        			'value' => \Elementor\Core\Schemes\Color::COLOR_3,
        		],
        		'default' =>  \Elementor\Core\Schemes\Color::COLOR_3,
        		'selectors' => [
        			'{{WRAPPER}} .breadcrumb_opt li , {{WRAPPER}} .breadcrumb_opt li a' => 'color: {{VALUE}}',
        		],
        	]
		);
		$this->add_control(
        	'breadcrumbs_color_active',
        	[
        		'label' => __( 'BreadCrumbs Color Active', 'elementpress' ),
        		'type' => Controls_Manager::COLOR,
        		'scheme' => [
        			'type' => \Elementor\Core\Schemes\Color::get_type(),
        			'value' => \Elementor\Core\Schemes\Color::COLOR_3,
        		],
        		'default' =>  \Elementor\Core\Schemes\Color::COLOR_3,
        		'selectors' => [
        			'{{WRAPPER}} .breadcrumb_opt li.single-the-title ,{{WRAPPER}} .breadcrumb_opt li.br-page-title' => 'color: {{VALUE}}',
				],
        	]
		);
		$this->add_responsive_control(
			'section-padding',
			[
				'label' => __( 'Padding', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .breadcrumb_opt > ul' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section(); //end style section
	}
	//front end rendering
    protected function render() {
		$settings = $this->get_settings_for_display();
		//get shortcodes file and display
		include_once(plugin_dir_path( __FILE__ ) .'shortcodes.php');?>
		<?php
      do_shortcode('[breadcrumb-opt]');
       ?>
	   <?php
  }
    protected function content_template() { }
}