<?php

namespace Elementor;
use Elementor\Core\Schemes\Typography as Scheme_Typography;
Use Elementor\Core\Schemes\Color as Scheme_Color;
if (!defined('ABSPATH')) exit;
 include('classes/walker-nav-menu.php');

class ElementPress_Widget_Nav_Menu extends \Elementor\Widget_Base
{
    public $base;

    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);

        wp_enqueue_script('elementpress-nav-menu', \ElementPress::widgets_url() . '/nav-menu/assets/js/script.js', array('jquery'), false, true);
        wp_register_style('elementpress-nav-menu-css', \ElementPress::widgets_url() . '/nav-menu/assets/css/style.css', false, \ElementPress::version, 'screen');
    }

    public function get_script_depends()
    {


        return ['elementpress-nav-menu'];
    }


    public function get_style_depends()
    {

        return ['elementpress-nav-menu-css'];
    }

    public function get_name()
    {
        return 'epress-nav-menu';
    }

    public function get_title()
    {
        return esc_html__('Nav menu', 'elementpress');
    }

    public function get_icon()
    {
        return 'eicon-posts-grid epress-widget-icon ';
    }

    public function get_categories()
    {
        return ['additional-addons'];
    }

    public function get_menus()
    {
        $list = [];
        $menus = wp_get_nav_menus();
        foreach ($menus as $menu) {
            $list[$menu->slug] = $menu->name;
        }
        return $list;
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'elementpress_content_tab',
            [
                'label' => esc_html__('Menu settings', 'elementpress'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'elementpress_nav_menu',
            [
                'label' => esc_html__('Select menu', 'elementpress'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => $this->get_menus(),
            ]
        );
        $this->add_control(
            'vertical_menu',
            [
                'label' => __('Horizontal  Align Menu', 'elementpress'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'elementpress'),
                'label_off' => __('Hide', 'elementpress'),
                'return_value' => 'no',
                'default' => 'no',
            ]
        );
        $this->add_responsive_control(
            'elementpress_vertical_menu_position',
            [
                'label' => esc_html__('Vertical main menu Alignment', 'elementpress'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'elementpress-vertical-left',
                'condition' => [
                    'vertical_menu' => '',
                ],
                'options' => [
                    'elementpress-vertical-left' => esc_html__('Left', 'elementpress'),
                    'elementpress-vertical-center' => esc_html__('Center', 'elementpress'),
                    'elementpress-vertical-right' => esc_html__('Right', 'elementpress'),
                ],

            ]
        );
        $this->add_control(
            'elementpress_nav_menu_logo',
            [
                'label' => __('Choose Mobile Menu Logo', 'elementpress'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'vertical_menu' => 'no',

                ],
            ]

        );
        $this->add_control(
            'elementpress_nav_menu_logo_link_to',
            [
                'label' => __('Link', 'elementpress'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'home',
                'options' => [
                    'home' => __('Home', 'elementpress'),
                    'custom' => __('Custom URL', 'elementpress'),
                ],

                'condition' => [
                    'vertical_menu' => 'no',
                ],
            ]
        );
        $this->add_control(
            'elementpress_nav_menu_logo_link',
            [
                'label' => __('Link', 'elementpress'),
                'type' => \Elementor\Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __('https://your-link.com', 'elementpress'),
                'condition' => [
                    'elementpress_nav_menu_logo_link_to' => 'custom',
                ],
                'condition' => [
                    'vertical_menu' => 'no',
                ],
                'show_label' => false,

            ]
        );
        $this->add_responsive_control(
            'elementpress_main_menu_position',
            [
                'label' => esc_html__('Horizontal main menu', 'elementpress'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'elementpress-menu-po-left',
                'options' => [
                    'elementpress-menu-po-left' => esc_html__('Left', 'elementpress'),
                    'elementpress-menu-po-center' => esc_html__('Center', 'elementpress'),
                    'elementpress-menu-po-right' => esc_html__('Right', 'elementpress'),
                    'elementpress-menu-po-justified' => esc_html__('Justified', 'elementpress'),
                ],
                'condition' => [
                    'vertical_menu' => 'no',
                ],
            ]
        );
        $this->add_responsive_control(
            'elementpress_border_radius',
            [
                'label' => esc_html__('Border radius', 'elementpress'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'devices' => ['desktop', 'tablet'],
                'size_units' => ['px'],
                'desktop_default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 0,
                    'left' => 0,
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 0,
                    'left' => 0,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-menu-container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'vertical_menu' => 'no',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'elementpress_menubar_background',
                'label' => esc_html__('Background', 'elementpress'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .elementpress-menu-container',
            ]
        );
        $this->add_responsive_control(
            'elementpress_mobile_menu_panel_background',
            [
                'label' => esc_html__('Item text color', 'elementpress'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'tablet_default' => esc_html__('#ffffff', 'elementpress'),
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                
                'selectors' => [
                    '{{WRAPPER}} .elementpress-menu-container' => 'background-image: linear-gradient(180deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
                'condition' => [
                    'vertical_menu' => 'no',
                ],
            ]
        );
        $this->add_responsive_control(
            'elementpress_mobile_menu_panel_spacing',
            [
                'label' => __('Padding', 'elementpress'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'tablet_default' => [
                    'top' => '10',
                    'right' => '0',
                    'bottom' => '10',
                    'left' => '0',
                    'unit' => 'px',
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-nav-identity-panel' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'elementpress_mobile_menu_panel_width',
            [
                'label' => esc_html__('Width', 'elementpress'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'range' => [
                    'px' => [
                        'min' => 350,
                        'max' => 700,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'tablet_default' => [
                    'size' => 350,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-menu-container' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'elementpress_style_tab_menuitem',
            [
                'label' => esc_html__('Menu item style', 'elementpress'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'elementpress_menu_text_color',
            [
                'label' => esc_html__('Item text color', 'elementpress'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'desktop_default' => esc_html__('#000000', 'elementpress'),
                'tablet_default' => esc_html__('#000000', 'elementpress'),
                'devices' => ['desktop', 'tablet'],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-navbar-nav > li > a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'elementpress_item_background',
                'label' => esc_html__('Item background', 'elementpress'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .elementpress-navbar-nav > li > a',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'elementpress_content_typography',
                'label' => esc_html__('Typography', 'elementpress'),
                'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .elementpress-navbar-nav > li > a',
            ]
        );
        $this->add_responsive_control(
            'elementpress_menu_item_spacing',
            [
                'label' => esc_html__('Padding', 'elementpress'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'devices' => ['desktop', 'tablet'],
                'desktop_default' => [
                    'top' => 0,
                    'right' => 15,
                    'bottom' => 0,
                    'left' => 15,
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'top' => 10,
                    'right' => 15,
                    'bottom' => 10,
                    'left' => 15,
                    'unit' => 'px',
                ],
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-navbar-nav > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'elementpress_menu_items_margin',
            [
                'label' => esc_html__('Margin', 'elementpress'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'devices' => ['desktop', 'tablet', 'mobile'],
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-navbar-nav > li > a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'elementpress_title_one',
            [
                'label' => esc_html__('Hover', 'elementpress'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'elementpress_item_background_hover',
                'label' => esc_html__('Item background', 'elementpress'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .elementpress-navbar-nav > li > a:hover, {{WRAPPER}} .elementpress-navbar-nav > li > a:focus, {{WRAPPER}} .elementpress-navbar-nav > li > a:active, {{WRAPPER}} .elementpress-navbar-nav > li:hover > a',
            ]
        );
        $this->add_control(
            'elementpress_item_color_hover',
            [
                'label' => esc_html__('Item text color (hover)', 'elementpress'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => esc_html__('#707070', 'elementpress'),
                'scheme' => [
                    'type' => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-navbar-nav > li > a:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .elementpress-navbar-nav > li > a:focus' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .elementpress-navbar-nav > li > a:active' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .elementpress-navbar-nav > li:hover > a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'elementpress_style_tab_submenu_item',
            [
                'label' => esc_html__('Submenu item style', 'elementpress'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vertical_menu' => 'no',
                ],
            ]
        );
        $this->add_control(
            'elementpress_style_tab_submenu_item_arrow',
            [
                'label' => esc_html__('Submenu Indicator', 'elementpress'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'elementpress_line_arrow',
                'options' => [
                    'elementpress_line_arrow' => esc_html__('Line Arrow', 'elementpress'),
                    'elementpress_plus_icon' => esc_html__('Plus', 'elementpress'),
                    'elementpress_fill_arrow' => esc_html__('Fill Arrow', 'elementpress'),
                    'elementpress_none' => esc_html__('None', 'elementpress'),
                ],
            ]
        );
        $this->add_responsive_control(
            'elementpress_submenu_item_spacing',
            [
                'label' => esc_html__('Spacing', 'elementpress'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'devices' => ['desktop', 'tablet'],
                'desktop_default' => [
                    'top' => 15,
                    'right' => 10,
                    'bottom' => 15,
                    'left' => 10,
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'top' => 15,
                    'right' => 10,
                    'bottom' => 15,
                    'left' => 10,
                    'unit' => 'px',
                ],
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-navbar-nav .elementpress-submenu-panel > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'elementpress_menu_item_typography',
                'label' => esc_html__('Typography', 'elementpress'),
                'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .elementpress-navbar-nav .elementpress-submenu-panel > li > a',
            ]
        );
        $this->add_control(
            'elementpress_submenu_item_color',
            [
                'label' => esc_html__('Item text color', 'elementpress'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => esc_html__('#000000', 'elementpress'),
                'scheme' => [
                    'type' => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-navbar-nav .elementpress-submenu-panel > li > a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'elementpress_menu_item_background',
                'label' => esc_html__('Item background', 'elementpress'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .elementpress-navbar-nav .elementpress-submenu-panel > li > a',
            ]
        );
        $this->add_control(
            'elementpress_title_two',
            [
                'label' => esc_html__('Hover', 'elementpress'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'elementpress_item_text_color_hover',
            [
                'label' => esc_html__('Item text color (hover)', 'elementpress'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => esc_html__('#707070', 'elementpress'),
                'scheme' => [
                    'type' => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-navbar-nav .elementpress-submenu-panel > li > a:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .elementpress-navbar-nav .elementpress-submenu-panel > li > a:focus' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .elementpress-navbar-nav .elementpress-submenu-panel > li > a:active' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .elementpress-navbar-nav .elementpress-submenu-panel > li:hover > a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'elementpress_menu_item_background_hover',
                'label' => esc_html__('Item background (hover)', 'elementpress'),
                'types' => ['classic', 'gradient'],
                'selector' => '
                {{WRAPPER}} .elementpress-navbar-nav .elementpress-submenu-panel > li > a:hover,
                {{WRAPPER}} .elementpress-navbar-nav .elementpress-submenu-panel > li > a:focus,
                {{WRAPPER}} .elementpress-navbar-nav .elementpress-submenu-panel > li > a:active,
                {{WRAPPER}} .elementpress-navbar-nav .elementpress-submenu-panel > li:hover > a',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'elementpress_style_tab_submenu_panel',
            [
                'label' => esc_html__('Submenu panel style', 'elementpress'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vertical_menu' => 'no',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'elementpress_panel_submenu_border',
                'label' => esc_html__('Panel Menu Border', 'elementpress'),
                'selector' => '{{WRAPPER}} .elementpress-navbar-nav .elementpress-submenu-panel',
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'elementpress_submenu_container_background',
                'label' => esc_html__('Container background', 'elementpress'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .elementpress-navbar-nav .elementpress-submenu-panel',
            ]
        );
        $this->add_responsive_control(
            'elementpress_submenu_panel_border_radius',
            [
                'label' => esc_html__('Border Radius', 'elementpress'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'devices' => ['desktop', 'tablet'],
                'desktop_default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 0,
                    'left' => 0,
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 0,
                    'left' => 0,
                    'unit' => 'px',
                ],
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-navbar-nav .elementpress-submenu-panel' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'elementpress_submenu_container_width',
            [
                'label' => esc_html__('Conatiner width', 'elementpress'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'devices' => ['desktop', 'tablet'],
                'desktop_default' => esc_html__('220px', 'elementpress'),
                'tablet_default' => esc_html__('200px', 'elementpress'),
                'selectors' => [
                    '{{WRAPPER}} .elementpress-navbar-nav .elementpress-submenu-panel' => 'min-width: {{VALUE}};',
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'elementpress_panel_box_shadow',
                'label' => esc_html__('Box Shadow', 'elementpress'),
                'selector' => '{{WRAPPER}} .elementpress-navbar-nav .elementpress-submenu-panel',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'elementpress_menu_toggle_style_tab',
            [
                'label' => esc_html__('Humburder Style', 'elementpress'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vertical_menu' => 'no',
                ],
            ]
        );
        $this->add_control(
            'elementpress_menu_toggle_style_title',
            [
                'label' => esc_html__('Humburger Toggle', 'elementpress'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
            'elementpress_menu_toggle_icon_position',
            [
                'label' => esc_html__('Position', 'elementpress'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'label_block' => false,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Top', 'elementpress'),
                        'icon' => 'fa fa-angle-left',
                    ],
                    'right' => [
                        'title' => esc_html__('Middle', 'elementpress'),
                        'icon' => 'fa fa-angle-right',
                    ],
                ],
                'default' => 'right',
                'selectors' => [
                    '{{WRAPPER}} .elementpress-menu-hamburger' => 'float: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'elementpress_menu_toggle_spacing',
            [
                'label' => esc_html__('Padding', 'elementpress'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px',],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'tablet_default' => [
                    'top' => '8',
                    'right' => '8',
                    'bottom' => '8',
                    'left' => '8',
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-menu-hamburger' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'elementpress_menu_toggle_width',
            [
                'label' => esc_html__('Width', 'elementpress'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 45,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'tablet_default' => [
                    'unit' => 'px',
                    'size' => 45,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-menu-hamburger' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'elementpress_menu_toggle_border_radius',
            [
                'label' => esc_html__('Border Radius', 'elementpress'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'tablet_default' => [
                    'unit' => 'px',
                    'size' => 3,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-menu-hamburger' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->start_controls_tabs(
            'elementpress_menu_toggle_normal_and_hover_tabs'
        );
        $this->start_controls_tab(
            'elementpress_menu_toggle_normal',
            [
                'label' => esc_html__('Normal', 'elementpress'),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'elementpress_menu_toggle_background',
                'label' => esc_html__('Background', 'elementpress'),
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .elementpress-menu-hamburger',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'elementpress_menu_toggle_border',
                'label' => esc_html__('Border', 'elementpress'),
                'separator' => 'before',
                'selector' => '{{WRAPPER}} .elementpress-menu-hamburger',
            ]
        );
        $this->add_control(
            'elementpress_menu_toggle_icon_color',
            [
                'label' => esc_html__('Humber Icon Color', 'elementpress'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'scheme' => [
                    'type' => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'default' => esc_html__('rgba(0, 0, 0, 0.5)', 'elementpress'),
                'selectors' => [
                    '{{WRAPPER}} .elementpress-menu-hamburger .elementpress-menu-hamburger-icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'elementpress_menu_toggle_hover',
            [
                'label' => esc_html__('Hover', 'elementpress'),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'elementpress_menu_toggle_background_hover',
                'label' => esc_html__('Background', 'elementpress'),
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .elementpress-menu-hamburger:hover',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'elementpress_menu_toggle_border_hover',
                'label' => esc_html__('Border', 'elementpress'),
                'separator' => 'before',
                'selector' => '{{WRAPPER}} .elementpress-menu-hamburger:hover',
            ]
        );
        $this->add_control(
            'elementpress_menu_toggle_icon_color_hover',
            [
                'label' => esc_html__('Humber Icon Color', 'elementpress'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'scheme' => [
                    'type' => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'default' => esc_html__('rgba(0, 0, 0, 0.5)', 'elementpress'),
                'selectors' => [
                    '{{WRAPPER}} .elementpress-menu-hamburger:hover .elementpress-menu-hamburger-icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'elementpress_menu_close_style_title',
            [
                'label' => esc_html__('Close Toggle', 'elementpress'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'elementpress_menu_close_typography',
                'label' => __('Typography', 'elementpress'),
                'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .elementpress-menu-close',
            ]
        );
        $this->add_responsive_control(
            'elementpress_menu_close_spacing',
            [
                'label' => esc_html__('Padding', 'elementpress'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px',],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'tablet_default' => [
                    'top' => '8',
                    'right' => '8',
                    'bottom' => '8',
                    'left' => '8',
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-menu-close' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'elementpress_menu_close_margin',
            [
                'label' => esc_html__('Margin', 'elementpress'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px',],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'tablet_default' => [
                    'top' => '12',
                    'right' => '12',
                    'bottom' => '12',
                    'left' => '12',
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-menu-close' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'elementpress_menu_close_width',
            [
                'label' => esc_html__('Width', 'elementpress'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 45,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'tablet_default' => [
                    'unit' => 'px',
                    'size' => 45,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-menu-close' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'elementpress_menu_close_border_radius',
            [
                'label' => esc_html__('Border Radius', 'elementpress'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'tablet_default' => [
                    'unit' => 'px',
                    'size' => 3,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-menu-close' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->start_controls_tabs(
            'elementpress_menu_close_normal_and_hover_tabs'
        );
        $this->start_controls_tab(
            'elementpress_menu_close_normal',
            [
                'label' => esc_html__('Normal', 'elementpress'),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'elementpress_menu_close_background',
                'label' => esc_html__('Background', 'elementpress'),
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .elementpress-menu-close',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'elementpress_menu_close_border',
                'label' => esc_html__('Border', 'elementpress'),
                'separator' => 'before',
                'selector' => '{{WRAPPER}} .elementpress-menu-close',
            ]
        );
        $this->add_control(
            'elementpress_menu_close_icon_color',
            [
                'label' => esc_html__('Humber Icon Color', 'elementpress'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'scheme' => [
                    'type' => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'default' => esc_html__('rgba(51, 51, 51, 1)', 'elementpress'),
                'selectors' => [
                    '{{WRAPPER}} .elementpress-menu-close' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'elementpress_menu_close_hover',
            [
                'label' => esc_html__('Hover', 'elementpress'),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'elementpress_menu_close_background_hover',
                'label' => esc_html__('Background', 'elementpress'),
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .elementpress-menu-close:hover',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'elementpress_menu_close_border_hover',
                'label' => esc_html__('Border', 'elementpress'),
                'separator' => 'before',
                'selector' => '{{WRAPPER}} .elementpress-menu-close:hover',
            ]
        );
        $this->add_control(
            'elementpress_menu_close_icon_color_hover',
            [
                'label' => esc_html__('Humber Icon Color', 'elementpress'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'scheme' => [
                    'type' => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'default' => esc_html__('rgba(0, 0, 0, 0.5)', 'elementpress'),
                'selectors' => [
                    '{{WRAPPER}} .elementpress-menu-close:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section(
            'elementpress_mobile_menu_logo_style_tab',
            [
                'label' => __('Mobile Menu Logo', 'elementpress'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'elementpress_mobile_menu_logo_width',
            [
                'label' => __('Width', 'elementpress'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 5,
                    ],
                ],
                'tablet_default' => [
                    'unit' => 'px',
                    'size' => 160,
                ],
                'mobile_default' => [
                    'unit' => 'px',
                    'size' => 120,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-nav-logo > img' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'elementpress_mobile_menu_logo_height',
            [
                'label' => __('Height', 'elementpress'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ],
                ],
                'tablet_default' => [
                    'unit' => 'px',
                    'size' => 60,
                ],
                'mobile_default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-nav-logo > img' => 'max-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'elementpress_mobile_menu_logo_margin',
            [
                'label' => __('Margin', 'elementpress'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'tablet_default' => [
                    'top' => '5',
                    'right' => '0',
                    'bottom' => '5',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => 'false',
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-nav-logo' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'elementpress_mobile_menu_logo_padding',
            [
                'label' => __('Padding', 'elementpress'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'tablet_default' => [
                    'top' => '5',
                    'right' => '5',
                    'bottom' => '5',
                    'left' => '5',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-nav-logo' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        echo '<div class="epress-wid-con" >';
        $this->render_raw();
        echo '</div>';
    }

    protected function render_raw()
    {
        $settings = $this->get_settings_for_display();
        if ($settings['elementpress_nav_menu'] != '') {
            $link = '';
            if ($settings['elementpress_nav_menu_logo_link_to'] == 'home') {
                $link = get_home_url();
            } else {
                $link = $settings['elementpress_nav_menu_logo_link']['url'];
            }
            $target = '';
            if ($settings['elementpress_nav_menu_logo_link']['is_external'] == "on") {
                $target = "_blank";
            } else {
                $target = "_self";
            }
            $nofollow = '';
            if ($settings['elementpress_nav_menu_logo_link']['nofollow'] == "on") {
                $nofollow = "nofollow";
            } else {
                $nofollow = "";
            }
            if ('' === $settings['vertical_menu']) {

                $item_style = "display:block;";
                $args = [
                    'items_wrap' => '<ul id="%1$s" style ="' . $item_style . '" class="%2$s">%3$s</ul>',
                    'container' => 'div',
                    'container_id' => 'epress-vertical-' . $settings['elementpress_nav_menu'],
                    'container_class' => 'elementpress-vertical-menu-container elementpress-navbar-nav-default ' . $settings['elementpress_style_tab_submenu_item_arrow'],
                    'menu_id' => 'footer-menu',
                    'menu' => $settings['elementpress_nav_menu'],
                    'menu_class' => 'elementpress-navbar-nav ' . $settings['elementpress_vertical_menu_position'],
                    'depth' => 4,
                    'echo' => true,
                    'fallback_cb' => 'wp_page_menu',
                ];
            }
            if ('no' === $settings['vertical_menu']) {

                $item_style = "";

                $markup = '
				<div class="elementpress-nav-identity-panel">
					<div class="elementpress-site-title">
						<a class="elementpress-nav-logo" href="' . $link . '" target="' . $target . '" rel="' . $nofollow . '">
							<img src="' . $settings['elementpress_nav_menu_logo']['url'] . '" alt="" >
						</a>
					</div>
					<button class="elementpress-menu-close elementpress-menu-toggler" type="button">X</button>
				</div>
			';
                $args = [
                    'items_wrap' => '<ul id="%1$s" style ="' . $item_style . '" class="%2$s">%3$s</ul>' . $markup,
                    'container' => 'div',
                    'container_id' => 'epress-megamenu-' . $settings['elementpress_nav_menu'],
                    'container_class' => 'elementpress-menu-container elementpress-menu-offcanvas-elements elementpress-navbar-nav-default ' . $settings['elementpress_style_tab_submenu_item_arrow'],
                    'menu_id' => 'main-menu',
                    'menu' => $settings['elementpress_nav_menu'],
                    'menu_class' => 'elementpress-navbar-nav ' . $settings['elementpress_main_menu_position'],
                    'depth' => 4,
                    'echo' => true,
                    'fallback_cb' => 'wp_page_menu',
                    'walker' => new \ElementPress_Menu_Walker()
                ];
            }
            wp_nav_menu($args);
        }
    }

    protected function content_template()
    {
    }
}