<?php
/**
 * @author : Jegtheme
 */
namespace EPRESS\Module\Post;

use EPRESS\Module\ModuleOptionAbstract;

Class Post_Feature_Option extends ModuleOptionAbstract
{
    public function get_category()
    {
        return esc_html__('EPRESS - Post', 'elementpress');
    }

    public function compatible_column()
    {
        return array( 1,2,3,4,5,6,7,8,9,10,11,12 );
    }

    public function get_module_name()
    {
        return esc_html__('ElementPress - Post Featured Image', 'elementpress');
    }

    public function set_options()
    {
        $this->set_post_option();
        $this->set_style_option();
    }

    public function set_post_option()
    {
        $this->options[] = array(
            'type'          => 'dropdown',
            'param_name'    => 'image_size',
            'heading'       => esc_html__('Featured Image Size', 'elementpress'),
            'description'   => esc_html__('choose which feature image size','elementpress'),
            'std'           => '1140x570',
            'value'         => array(
                esc_html__('1140x570', 'elementpress')                => '1140x570',
                esc_html__('750x375', 'elementpress')                 => '750x375',
                esc_html__('1140x815', 'elementpress')                => '1140x815',
                esc_html__('750x536', 'elementpress')                 => '750x536',
                esc_html__('Width 1140', 'elementpress')              => 'featured-1140',
                esc_html__('Width 750', 'elementpress')               => 'featured-750',
                esc_html__('Full Width', 'elementpress')              => 'full',
            )
        );

//        $this->options[] = array(
//            'type'          => 'dropdown',
//            'param_name'    => 'gallery_size',
//            'heading'       => esc_html__('Gallery Image Size', 'elementpress'),
//            'description'   => esc_html__('choose which gallery image size','elementpress'),
//            'std'           => '',
//            'value'         => array(
//                esc_html__('1140x570', 'elementpress')                => '1140x570',
//                esc_html__('750x375', 'elementpress')                 => '750x375',
//                esc_html__('1140x815', 'elementpress')                => '1140x815',
//                esc_html__('750x536', 'elementpress')                 => '750x536',
//                esc_html__('Width 1140', 'elementpress')              => 'featured-1140',
//                esc_html__('Width 750', 'elementpress')               => 'featured-750',
//            )
//        );
    }
}
