<?php
/**
 * @author : Jegtheme
 */
namespace EPRESS\Module\Element;

use EPRESS\Module\ModuleOptionAbstract;

Class Element_Iconlink_Option extends ModuleOptionAbstract
{
    public function compatible_column()
    {
        return array(1,2,3,4,5,6,7,8,9,10,11,12);
    }

    public function get_module_name()
    {
        return esc_html__('ElementPress - Icon Link', 'elementpress');
    }

    public function get_category()
    {
	    return esc_html__('EPRESS - Element', 'elementpress');
    }

	public function set_options()
    {
        $this->set_icon_option();
        $this->set_style_option();
    }

    public function set_icon_option()
    {
        $this->options[] = array(
            'type'          => 'iconpicker',
            'param_name'    => 'icon',
            'heading'       => esc_html__('Icon', 'elementpress'),
            'description'   => esc_html__('Choose icon for this icon link', 'elementpress'),
            'std'         => 'fa fa-bolt',
            'settings'      => array(
                'emptyIcon'     => false,
                'iconsPerPage'  => 100,
            )
        );
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'title',
            'heading'       => esc_html__('Title', 'elementpress'),
            'description'   => esc_html__('Insert a text for block link title.', 'elementpress'),
        );
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'subtitle',
            'heading'       => esc_html__('Subtitle', 'elementpress'),
            'description'   => esc_html__('Sub title or short description.', 'elementpress'),
        );
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'title_url',
            'heading'       => esc_html__('Title URL', 'elementpress'),
            'description'   => esc_html__('Url of block link title.', 'elementpress'),
        );
        $this->options[] = array(
            'type'          => 'checkbox',
            'param_name'    => 'newtab',
            'heading'       => esc_html__('Open New Tab', 'elementpress'),
            'description'   => esc_html__('Check this option to open link on new tab.', 'elementpress'),
        );
    }

	public function set_typography_option( $instance ) {

        $instance->add_control(
            'icon_color',
            [
                'label' => esc_html__( 'Icon Color ', 'elementpress' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jeg_block_icon_link i' => 'color: {{VALUE}};',
                ],
            ]
        );


//        $instance->add_control(
//            'icon_hover_color',
//            [
//                'label' => esc_html__( 'Icon Hover Color ', 'elementpress' ),
//                'type' => \Elementor\Controls_Manager::COLOR,
//                'selectors' => [
//                    '{{WRAPPER}} .jeg_iconlink .jeg_iconlink:hover .jeg_block_icon_link i' => 'color: {{VALUE}};',
//                ],
//            ]
//        );
        $instance->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'elementpress' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jeg_block_icon_desc h3' => 'color: {{VALUE}};',
                ],
            ]
        );
        $instance->add_control(
            'subtitle_color',
            [
                'label' => esc_html__( 'SubTitle Color', 'elementpress' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jeg_iconlink .jeg_block_icon_desc_span span' => 'color: {{VALUE}};',
                ],
            ]
        );



		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'title_typography',
				'label'       => esc_html__( 'Title Typography', 'elementpress' ),
				'description' => esc_html__( 'Set typography for title', 'elementpress' ),
				'selector'    => '{{WRAPPER}} .jeg_block_icon_title h3',
			]
		);

		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'meta_typography',
				'label'       => esc_html__( 'Second Title Typography', 'elementpress' ),
				'description' => esc_html__( 'Set typography for second title', 'elementpress' ),
				'selector'    => '{{WRAPPER}} .jeg_block_icon_desc_span span',
			]
		);
	}
}
