<?php
/**
 * @author : Jegtheme
 */
namespace EPRESS\Module\Element;

use EPRESS\Module\ModuleOptionAbstract;

Class Element_Embedplaylist_Option extends ModuleOptionAbstract
{
    public function compatible_column()
    {
        return array( 4, 8 , 12 );
    }

    public function get_category()
    {
	    return esc_html__( 'EPRESS - Element', 'elementpress' );
    }

	public function show_color_scheme()
    {
        return false;
    }

    public function set_options()
    {
        $this->set_playlist_option();
        $this->set_style_option();
    }

    public function get_module_name()
    {
        return esc_html__('ElementPress - Youtube / Vimeo Playlist', 'elementpress');
    }

    public function set_playlist_option()
    {
        $api = epress_get_option( 'youtube-api', '' );

        if ( ! $api ) {
            $this->options[] = array(
                'type'        => 'alert',
                'param_name'  => 'compatible_column_notice',
                'heading'     => esc_html__( 'YouTube API ', 'elementpress' ),
                'description' => esc_html__( 'You are not yet enter you YouTube API, please go to Customizer > epress : Global API Option > Google API Key > YouTube API Key', 'elementpress' ),
                'std'         => 'error'
            );
        }

        $this->options[] = array(
            'type'          => 'dropdown',
            'param_name'    => 'layout',
            'heading'       => esc_html__('Video Playlist Layout', 'elementpress'),
            'description'   => esc_html__('Choose video playlist layout.', 'elementpress'),
            'std'           => 'default',
            'value'         => array(
                esc_html__('Horizontal', 'elementpress')    => 'horizontal',
                esc_html__('Vertical', 'elementpress')      => 'vertical',
            )
        );
        $this->options[] = array(
            'type'          => 'dropdown',
            'param_name'    => 'scheme',
            'heading'       => esc_html__('Video Playlist Scheme', 'elementpress'),
            'description'   => esc_html__('Choose video scheme color.', 'elementpress'),
            'std'           => 'light',
            'value'         => array(
                esc_html__('Light Scheme', 'elementpress')      => 'light',
                esc_html__('Dark Scheme', 'elementpress')    => 'dark',
            )
        );
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'playlist',
            'heading'       => esc_html__('YouTube / Vimeo Video', 'elementpress'),
            'description'   => esc_html__('Enter your youtube / vimeo video separated by comma (Ex : https://www.youtube.com/watch?v=IvcE4o36cAo, https://vimeo.com/180337696).', 'elementpress'),
        );
    }

	public function set_typography_option( $instance ) {

		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'title_typography',
				'label'       => esc_html__( 'Title Typography', 'elementpress' ),
				'description' => esc_html__( 'Set typography for title', 'elementpress' ),
				'selector'    => '{{WRAPPER}} .jeg_video_playlist_current_info a,{{WRAPPER}} .jeg_video_playlist_title',
			]
		);

		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'meta_typography',
				'label'       => esc_html__( 'Meta Typography', 'elementpress' ),
				'description' => esc_html__( 'Set typography for post meta', 'elementpress' ),
				'selector'    => '{{WRAPPER}} .jeg_video_playlist_category',
			]
		);
	}
}
