<?php
/**
 * @author : Jegtheme
 */
namespace EPRESS\Module\Block;

Class Block_22_Option extends BlockOptionAbstract
{
    protected $default_number_post = 6;
    protected $show_excerpt = false;
    protected $default_ajax_post = 3;

    public function get_module_name()
    {
        return esc_html__('ElementPress - Module 22', 'epress-ne');
    }

	public function set_style_option()
	{
		$this->set_boxed_option();
		parent::set_style_option();
	}

	public function set_typography_option( $instance ) {
		$instance->add_control(
			'tittle_color',
			[
				'label' => esc_html__( 'Title Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,	
				'label'       => esc_html__( 'Title Color', 'elementpress' ),
				'description' => esc_html__( 'Set Title Color for post title.', 'elementpress' ),
                
				'selectors' => [
					'{{WRAPPER}} .jeg_post_title  a' => 'color: {{VALUE}}',
					
				],
               
				
			]
		);

        $instance->add_control(
			'meta-color',
			[
				'label' => esc_html__( 'Meta Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,	
				'label'       => esc_html__( 'Meta  Color', 'elementpress' ),
				'description' => esc_html__( 'This option will change your meta color.', 'elementpress' ),
				'selectors' => [
					'{{WRAPPER}} .jeg_post_meta' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_post_meta .fa' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_postblock .jeg_subcat_list > li > a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_pl_md_card .jeg_post_category a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_postblock .jeg_subcat_list > li > a.current' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_meta_date a' => 'color: {{VALUE}}',

				],
               
				
			]
		);
        $instance->add_control(
			'acent-and-hover-color',
			[
				'label' => esc_html__( 'Accent Color & Link Hover
				', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,	
				'label'       => esc_html__( 'Accent Color & Link Hover
				', 'elementpress' ),
				'description' => esc_html__( 'This option will change your accent color.', 'elementpress' ),
				'selectors' => [
					'{{WRAPPER}} .jeg_meta_author a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_post_title a:hover' => 'color: {{VALUE}}',	
					
				],
                
				
			]
		);


		$instance->add_control(
			'background_color',
			[
				'label' => esc_html__( 'Expcerpt Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,	
				'description' => esc_html__( 'This option will change your excerpt color.', 'elementpress' ),
				'selectors' => [
					'{{WRAPPER}} .jeg_post_excerpt' => 'color: {{VALUE}}',
					
					
					
				],
               
				
			]
		);

		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'title_typography',
				'label'       => esc_html__( 'Title Typography', 'epress-ne' ),
				'description' => esc_html__( 'Set typography for post title', 'epress-ne' ),
				'selector'    => '{{WRAPPER}} .jeg_post_title > a',
			]
		);

		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'meta_typography',
				'label'       => esc_html__( 'Meta Typography', 'epress-ne' ),
				'description' => esc_html__( 'Set typography for post meta', 'epress-ne' ),
				'selector'    => '{{WRAPPER}} .jeg_post_meta, {{WRAPPER}} .jeg_post_meta .fa, {{WRAPPER}}.jeg_postblock .jeg_subcat_list > li > a:hover, {{WRAPPER}} .jeg_pl_md_card .jeg_post_category a, {{WRAPPER}}.jeg_postblock .jeg_subcat_list > li > a.current, {{WRAPPER}} .jeg_pl_md_5 .jeg_post_meta, {{WRAPPER}} .jeg_pl_md_5 .jeg_post_meta .fa, {{WRAPPER}} .jeg_post_category a',
			]
		);
	}
}
