<?php
/**
 * @author : Jegtheme
 */
namespace EPRESS\Module\Block;

use EPRESS\Module\ModuleOptionAbstract;

abstract Class BlockOptionAbstract extends ModuleOptionAbstract
{
    protected $default_number_post = 5;
    protected $show_excerpt = false;
    protected $show_ads = false;
    protected $default_ajax_post = 5;

    public function compatible_column()
    {
        return array( 4, 8 , 12 );
    }

    public function set_options()
    {
        $this->set_header_option();
        $this->set_header_filter_option();
        $this->set_content_filter_option($this->default_number_post);
        $this->set_content_setting_option($this->show_excerpt);
        $this->set_ajax_filter_option($this->default_ajax_post);
        $this->set_ads_setting_option($this->show_ads);
        $this->set_style_option();
    }

    protected function get_ad_size()
    {
        return array(
            esc_attr__('Auto', 'elementpress')              => 'auto',
            esc_attr__('Hide', 'elementpress')              => 'hide',
            esc_attr__('120 x 90', 'elementpress')          => '120x90',
            esc_attr__('120 x 240', 'elementpress')         => '120x240',
            esc_attr__('120 x 600', 'elementpress')         => '120x600',
            esc_attr__('125 x 125', 'elementpress')         => '125x125',
            esc_attr__('160 x 90', 'elementpress')          => '160x90',
            esc_attr__('160 x 600', 'elementpress')         => '160x600',
            esc_attr__('180 x 90', 'elementpress')          => '180x90',
            esc_attr__('180 x 150', 'elementpress')         => '180x150',
            esc_attr__('200 x 90', 'elementpress')          => '200x90',
            esc_attr__('200 x 200', 'elementpress')         => '200x200',
            esc_attr__('234 x 60', 'elementpress')          => '234x60',
            esc_attr__('250 x 250', 'elementpress')         => '250x250',
            esc_attr__('320 x 100', 'elementpress')         => '320x100',
            esc_attr__('300 x 250', 'elementpress')         => '300x250',
            esc_attr__('300 x 600', 'elementpress')         => '300x600',
            esc_attr__('320 x 50', 'elementpress')          => '320x50',
            esc_attr__('336 x 280', 'elementpress')         => '336x280',
            esc_attr__('468 x 15', 'elementpress')          => '468x15',
            esc_attr__('468 x 60', 'elementpress')          => '468x60',
            esc_attr__('728 x 15', 'elementpress')          => '728x15',
            esc_attr__('728 x 90', 'elementpress')          => '728x90',
            esc_attr__('970 x 90', 'elementpress')          => '970x90',
            esc_attr__('240 x 400', 'elementpress')         => '240x400',
            esc_attr__('250 x 360', 'elementpress')         => '250x360',
            esc_attr__('580 x 400', 'elementpress')         => '580x400',
            esc_attr__('750 x 100', 'elementpress')         => '750x100',
            esc_attr__('750 x 200', 'elementpress')         => '750x200',
            esc_attr__('750 x 300', 'elementpress')         => '750x300',
            esc_attr__('980 x 120', 'elementpress')         => '980x120',
            esc_attr__('930 x 180', 'elementpress')         => '930x180',
        );
    }

        // public function additional_style()
        // {

        //     $this->options[] = array(
        //         'type'          => 'colorpicker',
        //         'param_name'    => 'title_color',
        //         'group'         => esc_html__('Design', 'elementpress'),
        //         'heading'       => esc_html__('Title Color', 'elementpress'),
        //         'description'   => esc_html__('This option will change your Title color.', 'elementpress'),
        //         'selectors' => [
        //             '{{WRAPPER}} .jeg_post_title  a' => 'color: {{VALUE}}',
                    
        //         ],
        //     );

        //     $this->options[] = array(
        //         'type'          => 'colorpicker',
        //         'param_name'    => 'accent_color',
        //         'group'         => esc_html__('Design', 'elementpress'),
        //         'heading'       => esc_html__('Accent Color & Link Hover', 'elementpress'),
        //         'description'   => esc_html__('This option will change your accent color.', 'elementpress'),
        //     );

        //     $this->options[] = array(
        //         'type'          => 'colorpicker',
        //         'param_name'    => 'alt_color',
        //         'group'         => esc_html__('Design', 'elementpress'),
        //         'heading'       => esc_html__('Meta Color', 'elementpress'),
        //         'description'   => esc_html__('This option will change your meta color.', 'elementpress'),
        //     );

        //     $this->options[] = array(
        //         'type'          => 'colorpicker',
        //         'param_name'    => 'excerpt_color',
        //         'group'         => esc_html__('Design', 'elementpress'),
        //         'heading'       => esc_html__('Excerpt Color', 'elementpress'),
        //         'description'   => esc_html__('This option will change your excerpt color.', 'elementpress'),
        //     );
        // }

    /**
     * @return array
     */
    public function set_header_option()
    {
        $this->options[] = array(
            'type'          => 'iconpicker',
            'param_name'    => 'header_icon',
            'heading'       => esc_html__('Header Icon', 'elementpress'),
            'description'   => esc_html__('Choose icon for this block icon.', 'elementpress'),
            'group'         => esc_html__('Header', 'elementpress'),
            'std'         => '',
            'settings'      => array(
                'emptyIcon'     => true,
                'iconsPerPage'  => 100,
            )
        );
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'first_title',
            'holder'        => 'span',
            'heading'       => esc_html__('Title', 'elementpress'),
            'description'   => esc_html__('Main title of Module Block.', 'elementpress'),
            'group'         => esc_html__('Header', 'elementpress'),
        );
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'second_title',
            'holder'        => 'span',
            'heading'       => esc_html__('Second Title', 'elementpress'),
            'description'   => esc_html__('Secondary title of Module Block.', 'elementpress'),
            'group'         => esc_html__('Header', 'elementpress'),
        );
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'url',
            'heading'       => esc_html__('Title URL', 'elementpress'),
            'description'   => esc_html__('Insert URL of heading title.', 'elementpress'),
            'group'         => esc_html__('Header', 'elementpress'),
        );
        $this->options[] = array(
            'type'          => 'radioimage',
            'param_name'    => 'header_type',
            'std'           => 'heading_6',
            'value'         => array(
                EPRESS_URL . '/assets/img/admin/heading-1.png'  => 'heading_1',
                EPRESS_URL . '/assets/img/admin/heading-2.png'  => 'heading_2',
                EPRESS_URL . '/assets/img/admin/heading-3.png'  => 'heading_3',
                EPRESS_URL . '/assets/img/admin/heading-4.png'  => 'heading_4',
                EPRESS_URL . '/assets/img/admin/heading-5.png'  => 'heading_5',
                EPRESS_URL . '/assets/img/admin/heading-6.png'  => 'heading_6',
                EPRESS_URL . '/assets/img/admin/heading-7.png'  => 'heading_7',
                EPRESS_URL . '/assets/img/admin/heading-8.png'  => 'heading_8',
                EPRESS_URL . '/assets/img/admin/heading-9.png'  => 'heading_9',
            ),
            'heading'       => esc_html__('Header Type', 'elementpress'),
            'description'   => esc_html__('Choose which header type fit with your content design.', 'elementpress'),
            'group'         => esc_html__('Header', 'elementpress'),
        );
        $this->options[] = array(
            'type'          => 'colorpicker',
            'param_name'    => 'header_background',
            'heading'       => esc_html__('Header Background', 'elementpress'),
            'description'   => esc_html__('This option may not work for all of heading type.', 'elementpress'),
            'group'         => esc_html__('Header', 'elementpress'),
            'dependency'    => array('element' => "header_type", 'value' => array('heading_1', 'heading_2', 'heading_3', 'heading_4', 'heading_5'))
        );
        $this->options[] = array(
            'type'          => 'colorpicker',
            'param_name'    => 'header_secondary_background',
            'heading'       => esc_html__('Header Secondary Background', 'elementpress'),
            'description'   => esc_html__('change secondary background', 'elementpress'),
            'group'         => esc_html__('Header', 'elementpress'),
            'dependency'    => array('element' => "header_type", 'value' => array('heading_2'))
        );
        $this->options[] = array(
            'type'          => 'colorpicker',
            'param_name'    => 'header_text_color',
            'heading'       => esc_html__('Header Text Color', 'elementpress'),
            'description'   => esc_html__('Change color of your header text', 'elementpress'),
            'group'         => esc_html__('Header', 'elementpress'),
        );
        $this->options[] = array(
            'type'          => 'colorpicker',
            'param_name'    => 'header_line_color',
            'heading'       => esc_html__('Header line Color', 'elementpress'),
            'description'   => esc_html__('Change line color of your header', 'elementpress'),
            'group'         => esc_html__('Header', 'elementpress'),
            'dependency'    => array('element' => "header_type", 'value' => array('heading_1', 'heading_5', 'heading_6', 'heading_9'))
        );
        $this->options[] = array(
            'type'          => 'colorpicker',
            'param_name'    => 'header_accent_color',
            'heading'       => esc_html__('Header Accent', 'elementpress'),
            'description'   => esc_html__('Change Accent of your header', 'elementpress'),
            'group'         => esc_html__('Header', 'elementpress'),
            'dependency'    => array('element' => "header_type", 'value' => array('heading_6', 'heading_7'))
        );
    }

    /**
     * @return array
     */
    public function set_header_filter_option()
    {
        $this->options[] = array(
            'type'          => 'select',
            'multiple'      => PHP_INT_MAX,
            'ajax'          => 'epress_find_category',
            'options'       => 'epress_get_category_option',
            'nonce'         => wp_create_nonce('epress_find_category'),
            'param_name'    => 'header_filter_category',
            'heading'       => esc_html__('Category', 'elementpress'),
            'description'   => esc_html__('Add category filter for heading module.', 'elementpress'),
            'group'         => esc_html__('Header Filter', 'elementpress'),
            'std'           => '',
        );
        $this->options[] = array(
	        'type'          => 'select',
	        'multiple'      => PHP_INT_MAX,
	        'ajax'          => 'epress_find_author',
	        'options'       => 'epress_get_author_option',
	        'nonce'         => wp_create_nonce('epress_find_author'),
            'param_name'    => 'header_filter_author',
            'heading'       => esc_html__('Author', 'elementpress'),
            'description'   => esc_html__('Add author filter for heading module.', 'elementpress'),
            'group'         => esc_html__('Header Filter', 'elementpress'),
            'std'           => '',
        );
        $this->options[] = array(
	        'type'          => 'select',
	        'multiple'      => PHP_INT_MAX,
	        'ajax'          => 'epress_find_tag',
	        'options'       => 'epress_get_tag_option',
	        'nonce'         => wp_create_nonce('epress_find_tag'),
            'param_name'    => 'header_filter_tag',
            'heading'       => esc_html__('Tags', 'elementpress'),
            'description'   => esc_html__('Add tag filter for heading module.', 'elementpress'),
            'group'         => esc_html__('Header Filter', 'elementpress'),
            'std'           => '',
        );
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'header_filter_text',
            'heading'       => esc_html__('Default Text', 'elementpress'),
            'description'   => esc_html__('First item text on heading filter.', 'elementpress'),
            'group'         => esc_html__('Header Filter', 'elementpress'),
            'std'           => 'All'
        );
    }

    public function set_content_setting_option($show_excerpt = false)
    {
        $this->options[] = array(
            'type'          => 'dropdown',
            'param_name'    => 'date_format',
            'heading'       => esc_html__('Content Date Format', 'elementpress'),
            'description'   => esc_html__('Choose which date format you want to use.', 'elementpress'),
            'std'           => 'default',
            'group'         => esc_html__('Content Setting', 'elementpress'),
            'value'         => array(
                esc_html__('Relative Date/Time Format (ago)', 'elementpress')               => 'ago',
                esc_html__('WordPress Default Format', 'elementpress')      => 'default',
                esc_html__('Custom Format', 'elementpress')                 => 'custom',
            )
        );

        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'date_format_custom',
            'heading'       => esc_html__('Custom Date Format', 'elementpress'),
            'description'   => wp_kses(sprintf(__('Please write custom date format for your module, for more detail about how to write date format, you can refer to this <a href="%s" target="_blank">link</a>.', 'elementpress'), 'https://codex.wordpress.org/Formatting_Date_and_Time'), wp_kses_allowed_html()),
            'group'         => esc_html__('Content Setting', 'elementpress'),
            'std'           => 'Y/m/d',
            'dependency'    => array('element' => 'date_format', 'value' => array('custom'))
        );

        if($show_excerpt)
        {
            $this->options[] = array(
                'type'          => 'slider',
                'param_name'    => 'excerpt_length',
                'heading'       => esc_html__('Excerpt Length', 'elementpress'),
                'description'   => esc_html__('Set word length of excerpt on post block.', 'elementpress'),
                'group'         => esc_html__('Content Setting', 'elementpress'),
                'min'           => 0,
                'max'           => 200,
                'step'          => 1,
                'std'           => 20,
            );

            $this->options[] = array(
                'type'          => 'textfield',
                'param_name'    => 'excerpt_ellipsis',
                'heading'       => esc_html__('Excerpt Ellipsis', 'elementpress'),
                'description'   => esc_html__('Define excerpt ellipsis', 'elementpress'),
                'group'         => esc_html__('Content Setting', 'elementpress'),
                'std'           => '...'
            );
        }
    }

    public function set_ajax_filter_option($number = 10)
    {
        $this->options[] = array(
            'type'          => 'dropdown',
            'param_name'    => 'pagination_mode',
            'heading'       => esc_html__('Choose Pagination Mode', 'elementpress'),
            'description'   => esc_html__('Choose which pagination mode that fit with your block.', 'elementpress'),
            'group'         => esc_html__('Pagination', 'elementpress'),
            'std'           => 'disable',
            'value'         => array(
                esc_html__('No Pagination', 'elementpress')             => 'disable',
                esc_html__('Next Prev', 'elementpress')                 => 'nextprev',
                esc_html__('Load More', 'elementpress')                 => 'loadmore',
                esc_html__('Auto Load on Scroll', 'elementpress')       => 'scrollload',
            )
        );
        $this->options[] = array(
            'type'          => 'checkbox',
            'param_name'    => 'pagination_nextprev_showtext',
            'heading'       => esc_html__('Show Navigation Text', 'elementpress'),
            'value'         => array( esc_html__('Show Next/Prev text in the navigation controls.', 'elementpress') => 'no' ),
            'group'         => esc_html__('Pagination', 'elementpress'),
            'dependency'    => array('element' => "pagination_mode", 'value' => array('nextprev'))
        );
        $this->options[] = array(
            'type'          => 'slider',
            'param_name'    => 'pagination_number_post',
            'heading'       => esc_html__('Pagination Post', 'elementpress'),
            'description'   => esc_html__('Number of Post loaded during pagination request.', 'elementpress'),
            'group'         => esc_html__('Pagination', 'elementpress'),
            'min'           => 1,
            'max'           => 30,
            'step'          => 1,
            'std'           => $number,
            'dependency'    => array('element' => "pagination_mode", 'value' => array('nextprev','loadmore','scrollload'))
        );
        $this->options[] = array(
            'type'          => 'number',
            'param_name'    => 'pagination_scroll_limit',
            'heading'       => esc_html__('Auto Load Limit', 'elementpress'),
            'description'   => esc_html__('Limit of auto load when scrolling, set to zero to always load until end of content.', 'elementpress'),
            'group'         => esc_html__('Pagination', 'elementpress'),
            'min'           => 0,
            'max'           => 9999,
            'step'          => 1,
            'std'           => 0,
            'dependency'    => array('element' => "pagination_mode", 'value' => array('scrollload'))
        );
    }

    public function set_ads_setting_option( $show_ads = false )
    {
        if ( ! $show_ads ) return false;

        $this->options[] = array(
            'type'          => 'dropdown',
            'param_name'    => 'ads_type',
            'heading'       => esc_html__('Ads Type', 'elementpress'),
            'description'   => esc_html__('Choose which ads type you want to use.', 'elementpress'),
            'group'         => esc_html__('Ads', 'elementpress'),
            'std'           => 'disable',
            'value'         => array(
                esc_html__('Disable Ads', 'elementpress')   => 'disable',
                esc_html__('Image Ads', 'elementpress')     => 'image',
                esc_html__('Google Ads', 'elementpress')    => 'googleads',
                esc_html__('Script Code', 'elementpress')   => 'code'
            )
        );
        $this->options[] = array(
            'type'          => 'slider',
            'param_name'    => 'ads_position',
            'heading'       => esc_html__('Ads Position', 'elementpress'),
            'description'   => esc_html__('Set after certain number of post you want this advertisement to show.', 'elementpress'),
            'group'         => esc_html__('Ads', 'elementpress'),
            'dependency'    => Array('element' => "ads_type", 'value' => array('image', 'code', 'googleads')),
            'min'           => 1,
            'max'           => 10,
            'step'          => 1,
            'std'           => 1,
        );
        $this->options[] = array(
            'type'          => 'checkbox',
            'param_name'    => 'ads_random',
            'heading'       => esc_html__('Random Ads Position', 'elementpress'),
            'value'         => array( esc_html__("Set after random certain number of post you want this advertisement to show.", 'elementpress') => 'yes' ),
            'group'         => esc_html__('Ads', 'elementpress'),
            'dependency'    => Array('element' => "ads_type", 'value' => array('image', 'code', 'googleads'))
        );
        // IMAGE
        $this->options[] = array(
            'type'          => 'attach_image',
            'param_name'    => 'ads_image',
            'heading'       => esc_html__('Ads Image', 'elementpress'),
            'description'   => esc_html__('Upload your ads image.', 'elementpress'),
            'group'         => esc_html__('Ads', 'elementpress'),
            'dependency'    => Array('element' => "ads_type", 'value' => array('image'))
        );
	    $this->options[] = array(
		    'type'          => 'attach_image',
		    'param_name'    => 'ads_image_tablet',
		    'heading'       => esc_html__('Ads Image Tablet', 'elementpress'),
		    'description'   => esc_html__('Upload your ads image that will be shown on the tablet view.', 'elementpress'),
		    'group'         => esc_html__('Ads', 'elementpress'),
		    'dependency'    => Array('element' => "ads_type", 'value' => array('image'))
	    );
	    $this->options[] = array(
		    'type'          => 'attach_image',
		    'param_name'    => 'ads_image_phone',
		    'heading'       => esc_html__('Ads Image Phone', 'elementpress'),
		    'description'   => esc_html__('Upload your ads image that will be shown on the phone view.', 'elementpress'),
		    'group'         => esc_html__('Ads', 'elementpress'),
		    'dependency'    => Array('element' => "ads_type", 'value' => array('image'))
	    );
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'ads_image_link',
            'heading'       => esc_html__('Ads Image Link', 'elementpress'),
            'description'   => esc_html__('Insert link of your image ads.','elementpress'),
            'group'         => esc_html__('Ads', 'elementpress'),
            'dependency'    => Array('element' => "ads_type", 'value' => array('image'))
        );
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'ads_image_alt',
            'heading'       => esc_html__('Image Alternate Text','elementpress'),
            'description'   => esc_html__('Insert alternate of your ads image.','elementpress'),
            'group'         => esc_html__('Ads', 'elementpress'),
            'dependency'    => Array('element' => "ads_type", 'value' => array('image'))
        );
        $this->options[] = array(
            'type'          => 'checkbox',
            'param_name'    => 'ads_image_new_tab',
            'heading'       => esc_html__('Open New Tab','elementpress'),
            'value'         => array( esc_html__("Open in new tab when ads image clicked.", 'elementpress') => 'yes' ),
            'group'         => esc_html__('Ads', 'elementpress'),
            'dependency'    => Array('element' => "ads_type", 'value' => array('image'))
        );
        // GOOGLE
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'google_publisher_id',
            'heading'       => esc_html__('Publisher ID','elementpress'),
            'description'   => esc_html__('Insert data-ad-client / google_ad_client content.','elementpress'),
            'group'         => esc_html__('Ads', 'elementpress'),
            'dependency'    => Array('element' => "ads_type", 'value' => array('googleads'))
        );
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'google_slot_id',
            'heading'       => esc_html__('Ads Slot ID','elementpress'),
            'description'   => esc_html__('Insert data-ad-slot / google_ad_slot content.','elementpress'),
            'group'         => esc_html__('Ads', 'elementpress'),
            'dependency'    => Array('element' => "ads_type", 'value' => array('googleads'))
        );
        $this->options[] = array(
            'type'          => 'dropdown',
            'param_name'    => 'google_desktop',
            'heading'       => esc_html__('Desktop Ads Size','elementpress'),
            'description'   => esc_html__('Choose ads size to show on desktop.','elementpress'),
            'group'         => esc_html__('Ads', 'elementpress'),
            'dependency'    => Array('element' => "ads_type", 'value' => array('googleads')),
            'std'           => 'auto',
            'value'         => $this->get_ad_size()
        );
        $this->options[] = array(
            'type'          => 'dropdown',
            'param_name'    => 'google_tab',
            'heading'       => esc_html__('Tab Ads Size','elementpress'),
            'description'   => esc_html__('Choose ads size to show on tab.','elementpress'),
            'group'         => esc_html__('Ads', 'elementpress'),
            'dependency'    => Array('element' => "ads_type", 'value' => array('googleads')),
            'std'           => 'auto',
            'value'         => $this->get_ad_size()
        );
        $this->options[] = array(
            'type'          => 'dropdown',
            'param_name'    => 'google_phone',
            'heading'       => esc_html__('Phone Ads Size','elementpress'),
            'description'   => esc_html__('Choose ads size to show on phone.','elementpress'),
            'group'         => esc_html__('Ads', 'elementpress'),
            'dependency'    => Array('element' => "ads_type", 'value' => array('googleads')),
            'std'           => 'auto',
            'value'         => $this->get_ad_size()
        );
        // CODE
        $this->options[] = array(
            'type'          => 'textarea_html',
            'param_name'    => 'content',
            'heading'       => esc_html__('Script Ads Code','elementpress'),
            'description'   => esc_html__('Put your full ads script right here.','elementpress'),
            'group'         => esc_html__('Ads', 'elementpress'),
            'dependency'    => Array('element' => "ads_type", 'value' => array('code'))
        );
        $this->options[] = array(
            'type'          => 'checkbox',
            'param_name'    => 'ads_bottom_text',
            'heading'       => esc_html__('Show Advertisement Text', 'elementpress'),
            'description'   => esc_html__('Show Advertisement Text on bottom of advertisement', 'elementpress'),
            'group'         => esc_html__('Ads', 'elementpress'),
            'dependency'    => Array('element' => "ads_type", 'value' => array('image'))
        );
    }

    protected function set_boxed_option()
    {
	    $this->options[] = array(
		    'type'          => 'checkbox',
		    'param_name'    => 'boxed',
		    'group'         => esc_html__('Design', 'elementpress'),
		    'heading'       => esc_html__('Enable Boxed', 'elementpress'),
		    'value'         => array( esc_html__("This option will turn the module into boxed.", 'elementpress') => 'true' ),
	    );

	    $this->options[] = array(
		    'type'          => 'checkbox',
		    'param_name'    => 'boxed_shadow',
		    'group'         => esc_html__('Design', 'elementpress'),
		    'heading'       => esc_html__('Enable Shadow', 'elementpress'),
		    'dependency'    => array('element' => "boxed", 'value' => 'true')
	    );
    }

    public function set_typography_option( $instance ) {

	    $instance->add_group_control(
		    \Elementor\Group_Control_Typography::get_type(),
		    [
			    'name'        => 'title_typography',
			    'label'       => esc_html__( 'Title Typography', 'elementpress' ),
			    'description' => esc_html__( 'Set typography for post title', 'elementpress' ),
			    'selector'    => '{{WRAPPER}} .jeg_post_title > a',
		    ]
	    );

	    $instance->add_group_control(
		    \Elementor\Group_Control_Typography::get_type(),
		    [
			    'name'        => 'meta_typography',
			    'label'       => esc_html__( 'Meta Typography', 'elementpress' ),
			    'description' => esc_html__( 'Set typography for post meta', 'elementpress' ),
			    'selector'    => '{{WRAPPER}} .jeg_post_meta, {{WRAPPER}} .jeg_post_meta .fa, {{WRAPPER}}.jeg_postblock .jeg_subcat_list > li > a:hover, {{WRAPPER}} .jeg_pl_md_card .jeg_post_category a, {{WRAPPER}}.jeg_postblock .jeg_subcat_list > li > a.current, {{WRAPPER}} .jeg_pl_md_5 .jeg_post_meta, {{WRAPPER}} .jeg_pl_md_5 .jeg_post_meta .fa, {{WRAPPER}} .jeg_post_category a',
		    ]
	    );

	    $instance->add_group_control(
		    \Elementor\Group_Control_Typography::get_type(),
		    [
			    'name'        => 'content_typography',
			    'label'       => esc_html__( 'Post Content Typography', 'elementpress' ),
			    'description' => esc_html__( 'Set typography for post content', 'elementpress' ),
			    'selector'    => '{{WRAPPER}} .jeg_post_excerpt, {{WRAPPER}} .jeg_readmore',
		    ]
        );
        $instance->add_control(
			'epress_category_switcher',
			[
				'label' => __( 'Category Style', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'elementpress' ),
				'label_off' => __( 'Hide', 'elementpress' ),
				'return_value' => 'yes',
				'default' => 'empty',
			]
        );
        $instance->add_control(
			'epress_category_color',
			[
				'label' => __( 'Category Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_3,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a' => 'color: {{VALUE}}',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],   
			]
        );
        $instance->add_control(
			'epress_category_hover_color',
			[
				'label' => __( 'Category Hover Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_3,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category:hover > a, {{WRAPPER}} .jeg_post_category:hover > span:hover > a' => 'color: {{VALUE}}',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],   
			]
        );
        
        $instance->add_control(
			'epress_category_bg_color',
			[
				'label' => __( 'Category Background Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_4,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a' => 'background: {{VALUE}}',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],   
			]
        );

        $instance->add_control(
			'epress_category_bg_hover_color',
			[
				'label' => __( 'Category Background Hover Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_4,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category:hover > a, {{WRAPPER}} .jeg_post_category:hover > span:hover > a' => 'background: {{VALUE}}',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],   
			]
        );

        $instance->add_group_control(
		    \Elementor\Group_Control_Typography::get_type(),
		    [
			    'name'        => 'category_typography',
			    'label'       => esc_html__( 'Category Typography', 'elementpress' ),
			    'description' => esc_html__( 'Set typography for post Category', 'elementpress' ),
			    'selector'    => '{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a',
                'condition'   => ['epress_category_switcher' => 'yes'],    
            ]
        );
        
		$instance->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'epress_cat_border',
				'label' => __( 'Border', 'elementpress' ),
                'selector' => '{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a',
                'condition'   => ['epress_category_switcher' => 'yes'],
			]
        );
        $instance->add_control(
			'epress_category_border_hover_color',
			[
				'label' => __( 'Category Border Hover Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_3,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category:hover > a, {{WRAPPER}} .jeg_post_category:hover > span:hover > a' => 'border-color: {{VALUE}}',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],   
			]
        );
        $instance->add_control(
			'epress_category_border_radius',
			[
				'label' => __( 'Category Border Radius', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],
			]
        );
        $instance->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => __( 'Box Shadow', 'elementpress' ),
                'selector' => '{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a',
                'condition'   => ['epress_category_switcher' => 'yes'],
			]
		);

        $instance->add_control(
			'epress_category_margin',
			[
				'label' => __( 'Category Margin', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],
			]
		);
        $instance->add_control(
			'epress_category_padding',
			[
				'label' => __( 'Category Padding', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],
			]
		);
        
        $instance->add_responsive_control(
            'epress_image_width',
            [
                'label' => __('Image Resize', 'elementpress'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'devices' => ['desktop','tablet','mobile'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .jeg_thumb' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $instance->add_control(
			'epress_button_switcher',
			[
				'label' => __( 'Button Style', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'elementpress' ),
				'label_off' => __( 'Hide', 'elementpress' ),
				'return_value' => 'yes',
				'default' => 'empty',
			]
        );

        $instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'button_content_typography',
				'label' => __( 'Button Typography', 'elementpress' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .jeg_readmore',
                'condition' => ['epress_button_switcher' => 'yes'
                ],
			]
        );
        $instance->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow_2',
				'label' => __( 'Box Shadow', 'elementpress' ),
                'selector' => '{{WRAPPER}} .jeg_readmore',
                'condition' => ['epress_button_switcher' => 'yes'],
			]
        );
        
		$instance->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'epress_button_border',
				'label' => __( 'Border', 'elementpress' ),
				'selector' => '{{WRAPPER}} .jeg_readmore',
                'condition' => ['epress_button_switcher'=>'yes'
                ],
            ]
		);

        $instance->add_control(
			'epress_button_border_radius',
			[
				'label' => __( 'Button Border Radius', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .jeg_readmore' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => ['epress_button_switcher'=>'yes'
                ],
			]
        );
        $instance->add_control(
			'epress_button_border_hover_color',
			[
				'label' => __( 'Border Hover Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_readmore:hover' => 'border-color: {{VALUE}}',
                ],
                'condition' => ['epress_button_switcher'=>'yes'
                ],
			]
		);
		$instance->add_control(
			'epress_button_color',
			[
				'label' => __( 'Button Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_3,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_readmore' => 'color: {{VALUE}}',
                ],
                'condition' => ['epress_button_switcher'=>'yes'
                ],
			]
		);
        $instance->add_control(
			'epress_button_hover_color',
			[
				'label' => __( 'Button Hover Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_readmore:hover' => 'color: {{VALUE}}',
                ],
                'condition' => ['epress_button_switcher'=>'yes'
                ],
			]
		);
        $instance->add_control(
			'epress_button_bg_color',
			[
				'label' => __( 'Button Background Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_4,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_readmore' => 'background-color: {{VALUE}}',
                ],
                'condition' => ['epress_button_switcher'=>'yes'
                ],
			]
        );
        $instance->add_control(
			'epress_button_bg_hover_color',
			[
				'label' => __( 'Button Background Hover Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_readmore:hover' => 'background-color: {{VALUE}}',
                ],
                'condition' => ['epress_button_switcher'=>'yes'
                ],
			]
        );
        $instance->add_control(
			'epress_button_padding',
			[
				'label' => __( 'Button Padding', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .jeg_readmore' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => ['epress_button_switcher'=>'yes'
                ],
			]
        );
        $instance->add_control(
			'epress_button_margin',
			[
				'label' => __( 'Button Margin', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .jeg_readmore' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => ['epress_button_switcher'=>'yes'
                ],
			]
        );
        $instance->add_control(
            'epress_display_meta_admin',
            [
                'label' => __( 'Hide Meta Admin', 'elementpress' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'On', 'elementpress' ),
                'label_off' => __( 'Off', 'elementpress' ),
                'return_value' => 'yes',
                // 'default' => 'empty',
                'selectors' => [
					'{{WRAPPER}} .jeg_meta_author, {{WRAPPER}} .jeg_meta_date::before' => 'display: none;',
                ],
            ]
        );
        $instance->add_control(
            'epress_display_meta_date',
            [
                'label' => __( 'Hide Meta Date', 'elementpress' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'On', 'elementpress' ),
                'label_off' => __( 'Off', 'elementpress' ),
                'return_value' => 'yes',
                // 'default' => 'empty',
                    'selectors' => [
                        '{{WRAPPER}} .jeg_meta_date' => 'display: none;',
                    ],
                
            ]
        );
        $instance->add_control(
            'epress_display_meta_comment',
            [
                'label' => __( 'Hide Meta comment', 'elementpress' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'On', 'elementpress' ),
                'label_off' => __( 'Off', 'elementpress' ),
                'return_value' => 'yes',
                // 'default' => 'empty',
                    'selectors' => [
                        '{{WRAPPER}} .jeg_meta_comment' => 'display: none;',
                    ],
                
            ]
        );
        ////////////////////////////////////////////////
            ///Margin Control of Block Start Here/// 
        ///////////////////////////////////////////////  
		$instance->add_control(
			'show_block_margin',
			[
				'label' => __( 'Remove Margin', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'elementpress' ),
				'label_off' => __( 'Hide', 'elementpress' ),
				'return_value' => 'yes',
				'default' => 'empty',
			]
		);
        
		$instance->add_control(
			'epress_margin_block',
			[
				'label' => __( 'Margin', 'elementpress' ),
				'type' =>  \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .jeg_post' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                ],
                'condition' => ['show_block_margin' => 'yes'],
			]
        );
        //////////////////////////////////////////////
            ///Margin Control of Block End Here/// 
        /////////////////////////////////////////////  

        $instance->add_control(
			'tittle_color',
			[
				'label' => esc_html__( 'Title Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,	
				'label'       => esc_html__( 'Title Color', 'elementpress' ),
				'description' => esc_html__( 'Set Title Color for post title.', 'elementpress' ),
                
				'selectors' => [
					'{{WRAPPER}} .jeg_post_title  a' => 'color: {{VALUE}}',
					
				],
               
				
			]
		);

        $instance->add_control(
			'meta-color',
			[
				'label' => esc_html__( 'Meta Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,	
				'label'       => esc_html__( 'Meta  Color', 'elementpress' ),
				'description' => esc_html__( 'This option will change your meta color.', 'elementpress' ),
				'selectors' => [
					'{{WRAPPER}} .jeg_post_meta' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_post_meta .fa' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_postblock .jeg_subcat_list > li > a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_pl_md_card .jeg_post_category a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_postblock .jeg_subcat_list > li > a.current' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_meta_date a' => 'color: {{VALUE}}',

				],
               
				
			]
		);
        $instance->add_control(
			'acent-and-hover-color',
			[
				'label' => esc_html__( 'Accent Color & Link Hover
				', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,	
				'label'       => esc_html__( 'Accent Color & Link Hover
				', 'elementpress' ),
				'description' => esc_html__( 'This option will change your accent color.', 'elementpress' ),
				'selectors' => [
					'{{WRAPPER}} .jeg_meta_author a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_post_title a:hover' => 'color: {{VALUE}}',	
					
				],
               
				
			]
		);


		$instance->add_control(
			'background_color',
			[
				'label' => esc_html__( 'Expcerpt Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,	
				'description' => esc_html__( 'This option will change your excerpt color.', 'elementpress' ),
				'selectors' => [
					'{{WRAPPER}} .jeg_post_excerpt' => 'color: {{VALUE}}',
					
					
					
				],
               
				
			]
		);

        
    }
  
}
