<?php

namespace App\Validation;

use CodeIgniter\Database\BaseConnection;

class InvoiceRules
{
    public function valid_datetime(string $str, ?string $format = 'Y-m-d H:i', array $data = []): bool
    {
        $d = \DateTime::createFromFormat($format, $str);
        return $d && $d->format($format) === $str;
    }

    public static function checkInvoiceExists($str, ?string $fields = null, array $data = [], ?BaseConnection &$db = null): bool
    {
        $db = $db ?? \Config\Database::connect();
        return $db->table('invoices')->where('id', $str)->countAllResults() > 0;
    }
    
    public static function checkInvoiceTestExists($str, ?string $fields = null, array $data = [], ?BaseConnection &$db = null): bool
    {
        $db = $db ?? \Config\Database::connect();
        return $db->table('invoice_tests')->where('id', $str)->countAllResults() > 0;
    }
}
