<?php

namespace App\Models;

use CodeIgniter\Model;

class TestModel extends Model
{
    protected $table            = 'tests';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['code', 'name', 'price'];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    protected array $casts = [];
    protected array $castHandlers = [];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    // protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [
        'id'    => 'permit_empty|integer',
        'code'  => 'required|integer|is_unique[tests.code,id,{id}]|greater_than[0]',
        'name'  => 'required|min_length[3]|max_length[100]',
        'price' => 'required|decimal',
    ];
    protected $validationMessages   = [
        'code' => [
            'is_unique' => 'The code must be unique.',
            'integer'   => 'The code must be a number.',
            'required'  => 'Code is required.',
            'greater_than' => 'Code must be greater than zero.'
        ],
        'name' => [
            'required' => 'Name is required.',
            'min_length' => 'Name must be at least 3 characters long.',
            'max_length' => 'Name cannot exceed 100 characters.'
        ],
        'price' => [
            'required' => 'Price is required.',
            'decimal'  => 'Price must be a decimal value.'
        ],
    ];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
}
