<?php

namespace App\Models;

use CodeIgniter\Model;

class InvoiceTestModel extends Model
{
    protected $table            = 'invoice_tests';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['invoice_id', 'test_id', 'price', 'status'];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    protected array $casts = [];
    protected array $castHandlers = [];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    // protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [
        'invoice_id' => 'required|integer|checkInvoiceExists',
        'test_id'    => 'required|integer|checkTestExists',
        'price' => 'required|decimal',
        'status' => 'in_list[Pending,Completed,Cancelled]',
    ];
    protected $validationMessages   = [
        'invoice_id' => [
            'required' => 'Invoice ID is required.',
            'integer'  => 'Invoice ID must be an integer.',
            'checkInvoiceExists' => 'Invoice ID must exist in the invoices table.',
        ],
        'test_id' => [
            'required' => 'Test ID is required.',
            'integer'  => 'Test ID must be an integer.',
            'checkTestExists' => 'Test ID must exist in the tests table.',
        ],
        'price' => [
            'required' => 'Price is required.',
            'decimal'  => 'Price must be a decimal value.',
        ],
        'status' => [
            'in_list' => 'Status must be one of the following: Pending, Completed, Cancelled.',
        ],
    ];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
}
