<?php

namespace App\Libraries;

use Firebase\JWT\JWT as FirebaseJWT;
use Firebase\JWT\Key;
use Exception;

class JWT
{
    protected $key;
    protected $algo;

    public function __construct()
    {
        $this->key = getenv('JWT_SECRET') ?: 'your-secret-key';
        $this->algo = 'HS256';
    }

    public function encode(array $payload): string
    {
        $issuedAt = time();
        $expire = $issuedAt + 3600; // 1 hour expiration

        $payload['iat'] = $issuedAt;
        $payload['exp'] = $expire;

        return FirebaseJWT::encode($payload, $this->key, $this->algo);
    }

    public function decode(string $token)
    {
        try {
            return FirebaseJWT::decode($token, new Key($this->key, $this->algo));
        } catch (Exception $e) {
            return false;
        }
    }
}
