<?php

namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

class AdminFilter implements FilterInterface
{
    /**
     * Do whatever processing this filter needs to do.
     * By default it should not return anything during
     * normal execution. However, when an abnormal state
     * is found, it should return an instance of
     * CodeIgniter\HTTP\Response. If it does, script
     * execution will end and that Response will be
     * sent back to the client, allowing for error pages,
     * redirects, etc.
     *
     * @param RequestInterface $request
     * @param array|null       $arguments
     *
     * @return RequestInterface|ResponseInterface|string|void
     */
    public function before(RequestInterface $request, $arguments = null)
    {
        $token = $_COOKIE['token'] ?? null;
        if (empty($token)) {
            return service('response')
                ->setStatusCode(401)
                ->setJSON(['error' => 'Unauthorized'])
                ->setHeader('Content-Type', 'application/json');
        }

        $decoded = service('jwt')->decode($token);
        if ($decoded === false) {
            return service('response')
                ->setStatusCode(401)
                ->setJSON(['error' => 'Invalid token'])
                ->setHeader('Content-Type', 'application/json');
        }

        if (!isset($decoded->role) || $decoded->role !== 'admin') {
            return service('response')
                ->setStatusCode(403)
                ->setJSON(['error' => 'Forbidden'])
                ->setHeader('Content-Type', 'application/json');
        }

        return $request;
    }

    /**
     * Allows After filters to inspect and modify the response
     * object as needed. This method does not allow any way
     * to stop execution of other after filters, short of
     * throwing an Exception or Error.
     *
     * @param RequestInterface  $request
     * @param ResponseInterface $response
     * @param array|null        $arguments
     *
     * @return ResponseInterface|void
     */
    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        //
    }
}
